/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.events.HeadUpdatedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.extensions.events.AbstractNoNotifyEvent;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SetHead
implements RestModifyView<ProjectResource, Input> {
    private static final Logger log = LoggerFactory.getLogger(SetHead.class);
    private final GitRepositoryManager repoManager;
    private final Provider<IdentifiedUser> identifiedUser;
    private final DynamicSet<HeadUpdatedListener> headUpdatedListeners;

    @Inject
    SetHead(GitRepositoryManager repoManager, Provider<IdentifiedUser> identifiedUser, DynamicSet<HeadUpdatedListener> headUpdatedListeners) {
        this.repoManager = repoManager;
        this.identifiedUser = identifiedUser;
        this.headUpdatedListeners = headUpdatedListeners;
    }

    public String apply(ProjectResource rsrc, Input input) throws AuthException, ResourceNotFoundException, BadRequestException, UnprocessableEntityException, IOException {
        if (!rsrc.getControl().isOwner()) {
            throw new AuthException("restricted to project owner");
        }
        if (input == null || Strings.isNullOrEmpty(input.ref)) {
            throw new BadRequestException("ref required");
        }
        String ref = RefNames.fullName(input.ref);
        Repository repo = this.repoManager.openRepository(rsrc.getNameKey());
        try {
            String newHead;
            Map<String, Ref> cur = repo.getRefDatabase().exactRef("HEAD", ref);
            if (!cur.containsKey(ref)) {
                throw new UnprocessableEntityException(String.format("Ref Not Found: %s", ref));
            }
            String oldHead = cur.get("HEAD").getTarget().getName();
            if (!oldHead.equals(newHead = ref)) {
                RefUpdate u = repo.updateRef("HEAD", true);
                u.setRefLogIdent(this.identifiedUser.get().newRefLogIdent());
                RefUpdate.Result res = u.link(newHead);
                switch (res) {
                    case NO_CHANGE: 
                    case RENAMED: 
                    case FORCED: 
                    case NEW: {
                        break;
                    }
                    default: {
                        throw new IOException("Setting HEAD failed with " + (Object)((Object)res));
                    }
                }
                this.fire(rsrc.getNameKey(), oldHead, newHead);
            }
            String string = ref;
            if (repo != null) {
                repo.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (repo != null) {
                    try {
                        repo.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RepositoryNotFoundException e) {
                throw new ResourceNotFoundException(rsrc.getName());
            }
        }
    }

    private void fire(Project.NameKey nameKey, String oldHead, String newHead) {
        if (!this.headUpdatedListeners.iterator().hasNext()) {
            return;
        }
        Event event = new Event(nameKey, oldHead, newHead);
        for (HeadUpdatedListener l : this.headUpdatedListeners) {
            try {
                l.onHeadUpdated(event);
            }
            catch (RuntimeException e) {
                log.warn("Failure in HeadUpdatedListener", e);
            }
        }
    }

    static class Event
    extends AbstractNoNotifyEvent
    implements HeadUpdatedListener.Event {
        private final Project.NameKey nameKey;
        private final String oldHead;
        private final String newHead;

        Event(Project.NameKey nameKey, String oldHead, String newHead) {
            this.nameKey = nameKey;
            this.oldHead = oldHead;
            this.newHead = newHead;
        }

        @Override
        public String getProjectName() {
            return this.nameKey.get();
        }

        @Override
        public String getOldHeadName() {
            return this.oldHead;
        }

        @Override
        public String getNewHeadName() {
            return this.newHead;
        }
    }

    public static class Input {
        @DefaultInput
        public String ref;
    }
}

