/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.base.Preconditions;
import com.google.gerrit.extensions.common.PluginDefinedInfo;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.index.IndexConfig;
import com.google.gerrit.index.QueryOptions;
import com.google.gerrit.index.query.IndexPredicate;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryProcessor;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountLimits;
import com.google.gerrit.server.index.change.ChangeIndexCollection;
import com.google.gerrit.server.index.change.ChangeIndexRewriter;
import com.google.gerrit.server.index.change.ChangeSchemaDefinitions;
import com.google.gerrit.server.index.change.IndexedChangeQuery;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.query.change.AndChangeSource;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIsVisibleToPredicate;
import com.google.gerrit.server.query.change.PluginDefinedAttributesFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ChangeQueryProcessor
extends QueryProcessor<ChangeData>
implements PluginDefinedAttributesFactory {
    private final Provider<ReviewDb> db;
    private final Provider<CurrentUser> userProvider;
    private final ChangeNotes.Factory notesFactory;
    private final DynamicMap<ChangeAttributeFactory> attributeFactories;
    private final PermissionBackend permissionBackend;

    @Inject
    ChangeQueryProcessor(Provider<CurrentUser> userProvider, AccountLimits.Factory limitsFactory, MetricMaker metricMaker, IndexConfig indexConfig, ChangeIndexCollection indexes, ChangeIndexRewriter rewriter, Provider<ReviewDb> db, ChangeNotes.Factory notesFactory, DynamicMap<ChangeAttributeFactory> attributeFactories, PermissionBackend permissionBackend) {
        super(metricMaker, ChangeSchemaDefinitions.INSTANCE, indexConfig, indexes, rewriter, "limit", () -> limitsFactory.create((CurrentUser)userProvider.get()).getQueryLimit());
        this.db = db;
        this.userProvider = userProvider;
        this.notesFactory = notesFactory;
        this.attributeFactories = attributeFactories;
        this.permissionBackend = permissionBackend;
    }

    public ChangeQueryProcessor enforceVisibility(boolean enforce) {
        super.enforceVisibility(enforce);
        return this;
    }

    @Override
    protected QueryOptions createOptions(IndexConfig indexConfig, int start, int limit, Set<String> requestedFields) {
        return IndexedChangeQuery.createOptions(indexConfig, start, limit, requestedFields);
    }

    @Override
    public List<PluginDefinedInfo> create(ChangeData cd) {
        ArrayList<PluginDefinedInfo> plugins = new ArrayList<PluginDefinedInfo>(this.attributeFactories.plugins().size());
        for (String plugin : this.attributeFactories.plugins()) {
            for (Provider<ChangeAttributeFactory> provider : this.attributeFactories.byPlugin(plugin).values()) {
                PluginDefinedInfo pda = null;
                try {
                    pda = provider.get().create(cd, this, plugin);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (pda == null) continue;
                pda.name = plugin;
                plugins.add(pda);
            }
        }
        if (plugins.isEmpty()) {
            plugins = null;
        }
        return plugins;
    }

    @Override
    protected Predicate<ChangeData> enforceVisibility(Predicate<ChangeData> pred) {
        return new AndChangeSource(pred, new ChangeIsVisibleToPredicate(this.db, this.notesFactory, this.userProvider.get(), this.permissionBackend), this.start);
    }

    static {
        Preconditions.checkState(!ChangeIsVisibleToPredicate.class.isAssignableFrom(IndexPredicate.class), "ChangeQueryProcessor assumes visibleto is not used by the index rewriter.");
    }

    public static interface ChangeAttributeFactory {
        public PluginDefinedInfo create(ChangeData var1, ChangeQueryProcessor var2, String var3);
    }
}

