/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_145;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.GC;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackConfig;

public class Schema_146
extends SchemaVersion {
    private static final String CREATE_ACCOUNT_MSG = "Create Account";
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private final PersonIdent serverIdent;
    private AtomicInteger i = new AtomicInteger();
    private Stopwatch sw = Stopwatch.createStarted();
    ReentrantLock gcLock = new ReentrantLock();
    private int size;

    @Inject
    Schema_146(Provider<Schema_145> prior, GitRepositoryManager repoManager, AllUsersName allUsersName, @GerritPersonIdent PersonIdent serverIdent) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.serverIdent = serverIdent;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        ui.message("Migrating accounts");
        Set<Map.Entry<Account.Id, Timestamp>> accounts = this.scanAccounts(db, ui).entrySet();
        ui.message("Run full gc as preparation for the migration");
        this.gc(ui);
        ui.message(String.format("... (%.3f s) full gc completed", this.elapsed()));
        HashSet<List<Map.Entry<Account.Id, Timestamp>>> batches = Sets.newHashSet(Iterables.partition(accounts, 500));
        ExecutorService pool = this.createExecutor(ui);
        try {
            batches.stream().forEach(batch -> pool.submit(() -> this.processBatch((List<Map.Entry<Account.Id, Timestamp>>)batch, ui)));
            pool.shutdown();
            pool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ui.message(String.format("... (%.3f s) Migrated all %d accounts to schema 146", this.elapsed(), this.i.get()));
        ui.message("Run full gc");
        this.gc(ui);
        ui.message(String.format("... (%.3f s) full gc completed", this.elapsed()));
    }

    private ExecutorService createExecutor(UpdateUI ui) {
        int threads;
        try {
            threads = Integer.parseInt(System.getProperty("threadcount"));
        }
        catch (NumberFormatException e) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        ui.message(String.format("... using %d threads ...", threads));
        return Executors.newFixedThreadPool(threads);
    }

    private void processBatch(List<Map.Entry<Account.Id, Timestamp>> batch, UpdateUI ui) {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);
             RevWalk rw = new RevWalk(repo);
             ObjectInserter oi = repo.newObjectInserter();){
            ObjectId emptyTree = Schema_146.emptyTree(oi);
            for (Map.Entry<Account.Id, Timestamp> e : batch) {
                boolean runFullGc;
                String refName = RefNames.refsUsers(e.getKey());
                Ref ref = repo.exactRef(refName);
                if (ref != null) {
                    this.rewriteUserBranch(repo, rw, oi, emptyTree, ref, e.getValue());
                } else {
                    this.createUserBranch(repo, oi, emptyTree, e.getKey(), e.getValue());
                }
                int count = this.i.incrementAndGet();
                this.showProgress(ui, count);
                if (count % 1000 != 0) continue;
                boolean bl = runFullGc = count % 100000 == 0;
                if (runFullGc) {
                    ui.message("Run full gc");
                }
                this.gc(repo, !runFullGc, ui);
                if (!runFullGc) continue;
                ui.message(String.format("... (%.3f s) full gc completed", this.elapsed()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private double elapsed() {
        return (double)this.sw.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
    }

    private void showProgress(UpdateUI ui, int count) {
        if (count % 100 == 0) {
            ui.message(String.format("... (%.3f s) migrated %d%% (%d/%d) accounts", this.elapsed(), Math.round(100.0 * (double)count / (double)this.size), count, this.size));
        }
    }

    private void gc(UpdateUI ui) {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            this.gc(repo, false, ui);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void gc(Repository repo, boolean refsOnly, UpdateUI ui) {
        if (repo instanceof FileRepository && this.gcLock.tryLock()) {
            TextProgressMonitor pm = null;
            try {
                pm = new TextProgressMonitor();
                FileRepository r = (FileRepository)repo;
                GC gc = new GC(r);
                gc.setProgressMonitor(pm);
                pm.beginTask("gc", 0);
                if (refsOnly) {
                    ui.message(String.format("... (%.3f s) pack refs", this.elapsed()));
                    gc.packRefs();
                } else {
                    PackConfig pconfig = new PackConfig(repo);
                    pconfig.setBuildBitmaps(false);
                    gc.setPackConfig(pconfig);
                    ui.message(String.format("... (%.3f s) gc --prune=now", this.elapsed()));
                    gc.setExpire(new Date());
                    gc.gc();
                }
            }
            catch (IOException | ParseException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.gcLock.unlock();
                if (pm != null) {
                    pm.endTask();
                }
            }
        }
    }

    private void rewriteUserBranch(Repository repo, RevWalk rw, ObjectInserter oi, ObjectId emptyTree, Ref ref, Timestamp registeredOn) throws IOException {
        RevCommit c;
        ObjectId current = this.createInitialEmptyCommit(oi, emptyTree, registeredOn);
        rw.reset();
        rw.sort(RevSort.TOPO);
        rw.sort(RevSort.REVERSE, true);
        rw.markStart(rw.parseCommit(ref.getObjectId()));
        while ((c = rw.next()) != null) {
            if (this.isInitialEmptyCommit(emptyTree, c)) {
                return;
            }
            CommitBuilder cb = new CommitBuilder();
            cb.setParentId(current);
            cb.setTreeId(c.getTree());
            cb.setAuthor(c.getAuthorIdent());
            cb.setCommitter(c.getCommitterIdent());
            cb.setMessage(c.getFullMessage());
            cb.setEncoding(c.getEncoding());
            current = oi.insert(cb);
        }
        oi.flush();
        RefUpdate ru = repo.updateRef(ref.getName());
        ru.setExpectedOldObjectId(ref.getObjectId());
        ru.setNewObjectId(current);
        ru.setForceUpdate(true);
        ru.setRefLogIdent(this.serverIdent);
        ru.setRefLogMessage(this.getClass().getSimpleName(), true);
        RefUpdate.Result result = ru.update();
        if (result != RefUpdate.Result.FORCED) {
            throw new IOException(String.format("Failed to update ref %s: %s", ref.getName(), result.name()));
        }
    }

    public void createUserBranch(Repository repo, ObjectInserter oi, ObjectId emptyTree, Account.Id accountId, Timestamp registeredOn) throws IOException {
        ObjectId id = this.createInitialEmptyCommit(oi, emptyTree, registeredOn);
        String refName = RefNames.refsUsers(accountId);
        RefUpdate ru = repo.updateRef(refName);
        ru.setExpectedOldObjectId(ObjectId.zeroId());
        ru.setNewObjectId(id);
        ru.setRefLogIdent(this.serverIdent);
        ru.setRefLogMessage(CREATE_ACCOUNT_MSG, false);
        RefUpdate.Result result = ru.update();
        if (result != RefUpdate.Result.NEW) {
            throw new IOException(String.format("Failed to update ref %s: %s", refName, result.name()));
        }
    }

    private ObjectId createInitialEmptyCommit(ObjectInserter oi, ObjectId emptyTree, Timestamp registrationDate) throws IOException {
        PersonIdent ident = new PersonIdent(this.serverIdent, registrationDate);
        CommitBuilder cb = new CommitBuilder();
        cb.setTreeId(emptyTree);
        cb.setCommitter(ident);
        cb.setAuthor(ident);
        cb.setMessage(CREATE_ACCOUNT_MSG);
        return oi.insert(cb);
    }

    private boolean isInitialEmptyCommit(ObjectId emptyTree, RevCommit c) {
        return c.getParentCount() == 0 && c.getTree().equals(emptyTree) && c.getShortMessage().equals(CREATE_ACCOUNT_MSG);
    }

    private static ObjectId emptyTree(ObjectInserter oi) throws IOException {
        return oi.insert(2, new byte[0]);
    }

    private Map<Account.Id, Timestamp> scanAccounts(ReviewDb db, UpdateUI ui) throws SQLException {
        ui.message(String.format("... (%.3f s) scan accounts", this.elapsed()));
        try (Statement stmt = Schema_146.newStatement(db);){
            HashMap<Account.Id, Timestamp> hashMap;
            block13: {
                ResultSet rs = stmt.executeQuery("SELECT account_id, registered_on FROM accounts");
                try {
                    HashMap<Account.Id, Timestamp> m = new HashMap<Account.Id, Timestamp>();
                    while (rs.next()) {
                        m.put(new Account.Id(rs.getInt(1)), rs.getTimestamp(2));
                    }
                    this.size = m.size();
                    hashMap = m;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
    }
}

