/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_158;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcExecutor;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class Schema_159
extends SchemaVersion {
    @Inject
    Schema_159(Provider<Schema_158> prior) {
        super(prior);
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        DraftWorkflowMigrationStrategy strategy = DraftWorkflowMigrationStrategy.WORK_IN_PROGRESS;
        if (ui.yesno(false, "Migrate draft changes to private changes (default is work-in-progress)")) {
            strategy = DraftWorkflowMigrationStrategy.PRIVATE;
        }
        ui.message(String.format("Replace draft changes with %s changes ...", strategy.name().toLowerCase()));
        try (JdbcExecutor e = Schema_159.newExecutor(db);){
            String column = strategy == DraftWorkflowMigrationStrategy.PRIVATE ? "is_private" : "work_in_progress";
            e.execute(String.format("UPDATE changes SET %s = 'Y',     status = 'n',     created_on = created_on WHERE status = 'd'   OR (status = 'n'       AND EXISTS         (SELECT *          FROM patch_sets          WHERE patch_sets.change_id = changes.change_id            AND patch_sets.draft = 'Y')) ", column));
        }
        ui.message("done");
    }

    private static enum DraftWorkflowMigrationStrategy {
        PRIVATE,
        WORK_IN_PROGRESS;

    }
}

