/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.RequestCleanup;
import com.google.gerrit.server.config.RequestScopedReviewDbProvider;
import com.google.gerrit.server.git.ProjectRunnable;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;

public abstract class RequestScopePropagator {
    private final Scope scope;
    private final ThreadLocalRequestContext local;
    private final Provider<RequestScopedReviewDbProvider> dbProviderProvider;

    protected RequestScopePropagator(Scope scope, ThreadLocalRequestContext local, Provider<RequestScopedReviewDbProvider> dbProviderProvider) {
        this.scope = scope;
        this.local = local;
        this.dbProviderProvider = dbProviderProvider;
    }

    public final <T> Callable<T> wrap(final Callable<T> callable) {
        final RequestContext callerContext = Preconditions.checkNotNull(this.local.getContext());
        final Callable<T> wrapped = this.wrapImpl(this.context(callerContext, this.cleanup(callable)));
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                if (callerContext == RequestScopePropagator.this.local.getContext()) {
                    return callable.call();
                }
                return wrapped.call();
            }

            public String toString() {
                return callable.toString();
            }
        };
    }

    public final Runnable wrap(final Runnable runnable) {
        final Callable<Object> wrapped = this.wrap(Executors.callable(runnable));
        if (runnable instanceof ProjectRunnable) {
            return new ProjectRunnable(){

                @Override
                public void run() {
                    try {
                        wrapped.call();
                    }
                    catch (Exception e) {
                        Throwables.throwIfUnchecked(e);
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public Project.NameKey getProjectNameKey() {
                    return ((ProjectRunnable)runnable).getProjectNameKey();
                }

                @Override
                public String getRemoteName() {
                    return ((ProjectRunnable)runnable).getRemoteName();
                }

                @Override
                public boolean hasCustomizedPrint() {
                    return ((ProjectRunnable)runnable).hasCustomizedPrint();
                }

                public String toString() {
                    return runnable.toString();
                }
            };
        }
        return new Runnable(){

            @Override
            public void run() {
                try {
                    wrapped.call();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String toString() {
                return runnable.toString();
            }
        };
    }

    protected abstract <T> Callable<T> wrapImpl(Callable<T> var1);

    protected <T> Callable<T> context(final RequestContext context, Callable<T> callable) {
        return () -> {
            RequestContext old = this.local.setContext(new RequestContext(){

                @Override
                public CurrentUser getUser() {
                    return context.getUser();
                }

                @Override
                public Provider<ReviewDb> getReviewDbProvider() {
                    return (Provider)RequestScopePropagator.this.dbProviderProvider.get();
                }
            });
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                this.local.setContext(old);
            }
        };
    }

    protected <T> Callable<T> cleanup(Callable<T> callable) {
        return () -> {
            RequestCleanup cleanup = this.scope.scope(Key.get(RequestCleanup.class), new Provider<RequestCleanup>(){

                @Override
                public RequestCleanup get() {
                    return new RequestCleanup();
                }
            }).get();
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                cleanup.run();
            }
        };
    }
}

