/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.internal.DelTemplateNamer;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class GenCallCodeUtils {
    private final Map<String, SoyJsSrcPrintDirective> soyJsSrcDirectivesMap;
    private final JsExprTranslator jsExprTranslator;
    private final DelTemplateNamer delTemplateNamer;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;

    @Inject
    protected GenCallCodeUtils(Map<String, SoyJsSrcPrintDirective> soyJsSrcDirectivesMap, JsExprTranslator jsExprTranslator, DelTemplateNamer delTemplateNamer, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory) {
        this.jsExprTranslator = jsExprTranslator;
        this.delTemplateNamer = delTemplateNamer;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
        this.soyJsSrcDirectivesMap = soyJsSrcDirectivesMap;
    }

    public CodeChunk.WithValue gen(CallNode callNode, TemplateAliases templateAliases, TranslationContext translationContext, ErrorReporter errorReporter) {
        CodeChunk.WithValue callee;
        if (callNode instanceof CallBasicNode) {
            callee = CodeChunk.dottedIdNoRequire(templateAliases.get(((CallBasicNode)callNode).getCalleeName()));
        } else {
            CallDelegateNode callDelegateNode = (CallDelegateNode)callNode;
            CodeChunk.WithValue calleeId = JsRuntime.SOY_GET_DELTEMPLATE_ID.call(CodeChunk.stringLiteral(this.delTemplateNamer.getDelegateName(callDelegateNode)));
            ExprRootNode variantSoyExpr = callDelegateNode.getDelCalleeVariantExpr();
            CodeChunk.WithValue variant = variantSoyExpr == null ? CodeChunk.WithValue.LITERAL_EMPTY_STRING : this.jsExprTranslator.translateToCodeChunk(variantSoyExpr, translationContext, errorReporter);
            callee = JsRuntime.SOY_GET_DELEGATE_FN.call(calleeId, variant, callDelegateNode.allowsEmptyDefault() ? CodeChunk.WithValue.LITERAL_TRUE : CodeChunk.WithValue.LITERAL_FALSE);
        }
        CodeChunk.WithValue objToPass = this.genObjToPass(callNode, templateAliases, translationContext, errorReporter);
        CodeChunk.WithValue call = callee.call(objToPass, CodeChunk.WithValue.LITERAL_NULL, JsRuntime.OPT_IJ_DATA);
        if (callNode.getEscapingDirectiveNames().isEmpty()) {
            return call;
        }
        JsExpr callResult = call.singleExprOrName();
        CodeChunk.RequiresCollector.IntoImmutableSet collector = new CodeChunk.RequiresCollector.IntoImmutableSet();
        call.collectRequires(collector);
        for (String directiveName : callNode.getEscapingDirectiveNames()) {
            SoyJsSrcPrintDirective directive = this.soyJsSrcDirectivesMap.get(directiveName);
            Preconditions.checkNotNull(directive, "Contextual autoescaping produced a bogus directive: %s", (Object)directiveName);
            callResult = directive.applyForJsSrc(callResult, ImmutableList.of());
            if (!(directive instanceof SoyLibraryAssistedJsSrcPrintDirective)) continue;
            for (String name : ((SoyLibraryAssistedJsSrcPrintDirective)directive).getRequiredJsLibNames()) {
                collector.add(GoogRequire.create(name));
            }
        }
        return CodeChunk.fromExpr(callResult, collector.get()).withInitialStatements(call.initialStatements());
    }

    private CodeChunk.WithValue genObjToPass(CallNode callNode, TemplateAliases templateAliases, TranslationContext translationContext, ErrorReporter errorReporter) {
        CodeChunk.WithValue dataToPass = callNode.dataAttribute().isPassingAllData() ? JsRuntime.OPT_DATA : (callNode.dataAttribute().isPassingData() ? this.jsExprTranslator.translateToCodeChunk(callNode.dataAttribute().dataExpr(), translationContext, errorReporter) : CodeChunk.WithValue.LITERAL_NULL);
        if (callNode.numChildren() == 0) {
            return dataToPass;
        }
        ImmutableList.Builder keys = ImmutableList.builder();
        ImmutableList.Builder values = ImmutableList.builder();
        for (CallParamNode child : callNode.getChildren()) {
            CodeChunk.WithValue content;
            keys.add(CodeChunk.WithValue.id(child.getKey()));
            if (child instanceof CallParamValueNode) {
                CallParamValueNode cpvn = (CallParamValueNode)child;
                CodeChunk.WithValue value = this.jsExprTranslator.translateToCodeChunk(cpvn.getExpr(), translationContext, errorReporter);
                values.add(value);
                continue;
            }
            CallParamContentNode cpcn = (CallParamContentNode)child;
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(cpcn)).booleanValue()) {
                List<CodeChunk.WithValue> chunks = this.genJsExprsVisitorFactory.create(translationContext, templateAliases, errorReporter).exec(cpcn);
                content = CodeChunkUtils.concatChunksForceString(chunks);
            } else {
                content = CodeChunk.WithValue.id("param" + cpcn.getId());
            }
            content = this.maybeWrapContent(translationContext.codeGenerator(), cpcn, content);
            values.add(content);
        }
        CodeChunk.WithValue params = CodeChunk.mapLiteral(keys.build(), values.build());
        if (callNode.dataAttribute().isPassingData()) {
            CodeChunk.WithValue allData = JsRuntime.SOY_ASSIGN_DEFAULTS.call(params, dataToPass);
            return allData;
        }
        return params;
    }

    protected CodeChunk.WithValue maybeWrapContent(CodeChunk.Generator generator, CallParamContentNode node, CodeChunk.WithValue content) {
        if (node.getContentKind() == null) {
            return content;
        }
        return JsRuntime.sanitizedContentOrdainerFunctionForInternalBlocks(node.getContentKind()).call(content);
    }
}

