/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.shared.restricted.SoyFunction;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public enum BuiltinFunction implements SoyFunction
{
    IS_FIRST("isFirst"),
    IS_LAST("isLast"),
    INDEX("index"),
    QUOTE_KEYS_IF_JS("quoteKeysIfJs"),
    CHECK_NOT_NULL("checkNotNull"),
    V1_EXPRESSION("v1Expression");

    private static final Map<String, BuiltinFunction> NONPLUGIN_FUNCTIONS_BY_NAME;
    private final String functionName;

    @Nullable
    public static BuiltinFunction forFunctionName(String functionName) {
        return NONPLUGIN_FUNCTIONS_BY_NAME.get(functionName);
    }

    private BuiltinFunction(String name) {
        this.functionName = name;
    }

    @Override
    public String getName() {
        return this.functionName;
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of(Integer.valueOf(1));
    }

    static {
        ImmutableMap.Builder<String, BuiltinFunction> mapBuilder = ImmutableMap.builder();
        for (BuiltinFunction nonpluginFn : BuiltinFunction.values()) {
            mapBuilder.put(nonpluginFn.functionName, nonpluginFn);
        }
        NONPLUGIN_FUNCTIONS_BY_NAME = mapBuilder.build();
    }
}

