/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.basetree.SyntaxVersionUpperBound;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.StrictHtmlMode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.SoyDocParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class TemplateNodeBuilder {
    private static final SoyErrorKind INVALID_SOYDOC_PARAM = SoyErrorKind.of("Found invalid soydoc param name ''{0}''");
    private static final SoyErrorKind INVALID_PARAM_NAMED_IJ = SoyErrorKind.of("Invalid param name ''ij'' (''ij'' is for injected data).");
    private static final SoyErrorKind KIND_BUT_NOT_STRICT = SoyErrorKind.of("kind=\"...\" attribute is only valid with autoescape=\"strict\".");
    private static final SoyErrorKind LEGACY_COMPATIBLE_PARAM_TAG = SoyErrorKind.of("Found invalid SoyDoc param tag ''{0}'', tags like this are only allowed in legacy templates marked ''deprecatedV1=\"true\"''.  The proper soydoc @param syntax is: ''@param <name> <optional comment>''. Soy does not understand JsDoc style type declarations in SoyDoc.");
    private static final SoyErrorKind PARAM_ALREADY_DECLARED = SoyErrorKind.of("Param ''{0}'' already declared");
    protected final TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo;
    protected final ErrorReporter errorReporter;
    protected Integer id;
    @Nullable
    protected SyntaxVersionUpperBound syntaxVersionBound;
    protected String cmdText;
    private String templateName;
    private String partialTemplateName;
    protected String templateNameForUserMsgs;
    protected Visibility visibility;
    private AutoescapeMode autoescapeMode;
    private ImmutableList<String> requiredCssNamespaces = ImmutableList.of();
    private String cssBaseNamespace;
    private SanitizedContent.ContentKind contentKind;
    protected String soyDoc;
    protected String soyDocDesc;
    @Nullable
    protected ImmutableList<TemplateParam> params;
    protected boolean isMarkedV1;
    protected StrictHtmlMode strictHtmlMode;
    SourceLocation sourceLocation;
    private static final Pattern NEWLINE = Pattern.compile("\\n|\\r\\n?");
    private static final Pattern SOY_DOC_START = Pattern.compile("^ [/][*][*] [\\ ]* \\r?\\n?", 4);
    private static final Pattern SOY_DOC_END = Pattern.compile("\\r?\\n? [\\ ]* [*][/] $", 4);
    private static final Pattern SOY_DOC_DECL_PATTERN = Pattern.compile("( @param[?]? ) \\s+ ( \\S+ )", 4);
    private static final Pattern SOY_DOC_PARAM_TEXT_PATTERN = Pattern.compile("[a-zA-Z_]\\w*", 4);

    protected TemplateNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, ErrorReporter errorReporter) {
        this.soyFileHeaderInfo = soyFileHeaderInfo;
        this.errorReporter = errorReporter;
        this.syntaxVersionBound = null;
        this.strictHtmlMode = StrictHtmlMode.UNSET;
    }

    public TemplateNodeBuilder setId(int id) {
        Preconditions.checkState(this.id == null);
        this.id = id;
        return this;
    }

    public TemplateNodeBuilder setSourceLocation(SourceLocation location) {
        Preconditions.checkState(this.sourceLocation == null);
        this.sourceLocation = Preconditions.checkNotNull(location);
        return this;
    }

    public abstract TemplateNodeBuilder setCommandValues(Identifier var1, List<CommandTagAttribute> var2);

    public String getTemplateNameForUserMsgs() {
        return this.templateNameForUserMsgs;
    }

    public TemplateNodeBuilder setSoyDoc(String soyDoc, SourceLocation soyDocLocation) {
        Preconditions.checkState(this.soyDoc == null);
        Preconditions.checkState(this.cmdText != null);
        this.soyDoc = soyDoc;
        Preconditions.checkArgument(soyDoc.startsWith("/**") && soyDoc.endsWith("*/"));
        String cleanedSoyDoc = TemplateNodeBuilder.cleanSoyDocHelper(soyDoc);
        this.soyDocDesc = TemplateNodeBuilder.parseSoyDocDescHelper(cleanedSoyDoc);
        this.addParams(this.parseSoyDocDeclsHelper(soyDoc, cleanedSoyDoc, soyDocLocation));
        return this;
    }

    public TemplateNodeBuilder addParams(Iterable<? extends TemplateParam> params) {
        HashSet<String> seenParamKeys = new HashSet<String>();
        if (this.params == null) {
            this.params = ImmutableList.copyOf(params);
        } else {
            for (TemplateParam templateParam : this.params) {
                seenParamKeys.add(templateParam.name());
            }
            this.params = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.params)).addAll(params)).build();
        }
        for (TemplateParam templateParam : params) {
            if (templateParam.name().equals("ij")) {
                this.errorReporter.report(templateParam.nameLocation(), INVALID_PARAM_NAMED_IJ, new Object[0]);
            }
            if (seenParamKeys.add(templateParam.name())) continue;
            this.errorReporter.report(templateParam.nameLocation(), PARAM_ALREADY_DECLARED, templateParam.name());
        }
        return this;
    }

    public abstract TemplateNode build();

    protected final void markDeprecatedV1(boolean isDeprecatedV1) {
        this.isMarkedV1 = isDeprecatedV1;
        if (isDeprecatedV1) {
            SyntaxVersionUpperBound newSyntaxVersionBound = new SyntaxVersionUpperBound(SyntaxVersion.V2_0, "Template is marked as deprecatedV1.");
            this.syntaxVersionBound = SyntaxVersionUpperBound.selectLower(this.syntaxVersionBound, newSyntaxVersionBound);
        }
    }

    protected void setAutoescapeInfo(AutoescapeMode autoescapeMode, @Nullable SanitizedContent.ContentKind contentKind, @Nullable SourceLocation kindLocation) {
        Preconditions.checkArgument(autoescapeMode != null);
        this.autoescapeMode = autoescapeMode;
        if (contentKind == null && autoescapeMode == AutoescapeMode.STRICT) {
            contentKind = SanitizedContent.ContentKind.HTML;
        } else if (contentKind != null && autoescapeMode != AutoescapeMode.STRICT) {
            this.errorReporter.report(kindLocation, KIND_BUT_NOT_STRICT, new Object[0]);
        }
        this.contentKind = contentKind;
    }

    Integer getId() {
        return this.id;
    }

    SyntaxVersionUpperBound getSyntaxVersionBound() {
        return this.syntaxVersionBound;
    }

    String getCmdText() {
        return this.cmdText;
    }

    String getSoyDoc() {
        return this.soyDoc;
    }

    String getSoyDocDesc() {
        return this.soyDocDesc;
    }

    protected AutoescapeMode getAutoescapeMode() {
        Preconditions.checkState(this.autoescapeMode != null);
        return this.autoescapeMode;
    }

    @Nullable
    public SanitizedContent.ContentKind getContentKind() {
        Preconditions.checkState(this.autoescapeMode != null);
        return this.contentKind;
    }

    protected ImmutableList<String> getRequiredCssNamespaces() {
        return Preconditions.checkNotNull(this.requiredCssNamespaces);
    }

    protected void setRequiredCssNamespaces(ImmutableList<String> requiredCssNamespaces) {
        this.requiredCssNamespaces = Preconditions.checkNotNull(requiredCssNamespaces);
    }

    protected String getCssBaseNamespace() {
        return this.cssBaseNamespace;
    }

    protected void setCssBaseNamespace(String cssBaseNamespace) {
        this.cssBaseNamespace = cssBaseNamespace;
    }

    protected final void setTemplateNames(String templateName, SourceLocation nameLocation, @Nullable String partialTemplateName) {
        this.templateName = templateName;
        this.partialTemplateName = partialTemplateName;
    }

    protected StrictHtmlMode getStrictHtmlMode() {
        return this.strictHtmlMode;
    }

    protected String getTemplateName() {
        return this.templateName;
    }

    @Nullable
    protected String getPartialTemplateName() {
        return this.partialTemplateName;
    }

    private static String cleanSoyDocHelper(String soyDoc) {
        soyDoc = NEWLINE.matcher(soyDoc).replaceAll("\n");
        soyDoc = soyDoc.replace("@deprecated", "&#64;deprecated");
        soyDoc = SOY_DOC_START.matcher(soyDoc).replaceFirst("");
        soyDoc = SOY_DOC_END.matcher(soyDoc).replaceFirst("");
        ArrayList<String> lines = Lists.newArrayList(Splitter.on(NEWLINE).split(soyDoc));
        TemplateNodeBuilder.removeCommonStartCharHelper(lines, ' ', true);
        if (TemplateNodeBuilder.removeCommonStartCharHelper(lines, '*', false) == 1) {
            TemplateNodeBuilder.removeCommonStartCharHelper(lines, ' ', true);
        }
        return Joiner.on('\n').join(lines);
    }

    private static int removeCommonStartCharHelper(List<String> lines, char charToRemove, boolean shouldRemoveMultiple) {
        int numCharsToRemove = 0;
        boolean isStillCounting = true;
        do {
            boolean areAllLinesEmpty = true;
            for (String line : lines) {
                if (line.length() == 0) continue;
                areAllLinesEmpty = false;
                if (line.length() > numCharsToRemove && line.charAt(numCharsToRemove) == charToRemove) continue;
                isStillCounting = false;
                break;
            }
            if (areAllLinesEmpty) {
                isStillCounting = false;
            }
            if (!isStillCounting) continue;
            ++numCharsToRemove;
        } while (isStillCounting && shouldRemoveMultiple);
        if (numCharsToRemove > 0) {
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (line.length() == 0) continue;
                lines.set(i, line.substring(numCharsToRemove));
            }
        }
        return numCharsToRemove;
    }

    private static String parseSoyDocDescHelper(String cleanedSoyDoc) {
        Matcher paramMatcher = SOY_DOC_DECL_PATTERN.matcher(cleanedSoyDoc);
        int endOfDescPos = paramMatcher.find() ? paramMatcher.start() : cleanedSoyDoc.length();
        String soyDocDesc = cleanedSoyDoc.substring(0, endOfDescPos);
        return CharMatcher.whitespace().trimTrailingFrom(soyDocDesc);
    }

    private List<SoyDocParam> parseSoyDocDeclsHelper(String originalSoyDoc, String cleanedSoyDoc, SourceLocation soyDocSourceLocation) {
        ArrayList<SoyDocParam> params = new ArrayList<SoyDocParam>();
        RawTextNode originalSoyDocAsNode = new RawTextNode(-1, originalSoyDoc, soyDocSourceLocation);
        Matcher matcher = SOY_DOC_DECL_PATTERN.matcher(cleanedSoyDoc);
        boolean isFound = matcher.find();
        while (isFound) {
            String declKeyword = matcher.group(1);
            String declText = matcher.group(2);
            String fullMatch = matcher.group();
            int indexOfParamName = originalSoyDoc.indexOf(declText, originalSoyDoc.indexOf(fullMatch));
            SourceLocation paramLocation = originalSoyDocAsNode.substringLocation(indexOfParamName, indexOfParamName + declText.length());
            int descStart = matcher.end();
            isFound = matcher.find();
            int descEnd = isFound ? matcher.start() : cleanedSoyDoc.length();
            String desc = cleanedSoyDoc.substring(descStart, descEnd).trim();
            if (declKeyword.equals("@param") || declKeyword.equals("@param?")) {
                if (SOY_DOC_PARAM_TEXT_PATTERN.matcher(declText).matches()) {
                    params.add(new SoyDocParam(declText, declKeyword.equals("@param"), desc, paramLocation));
                    continue;
                }
                if (declText.startsWith("{")) {
                    if (this.isMarkedV1) continue;
                    this.errorReporter.report(paramLocation, LEGACY_COMPATIBLE_PARAM_TAG, declText);
                    continue;
                }
                this.errorReporter.report(paramLocation, INVALID_SOYDOC_PARAM, declText);
                continue;
            }
            throw new AssertionError();
        }
        return params;
    }
}

