/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.Context;
import org.parboiled.ContextAware;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.process.RuleMethodProcessor;

public abstract class GroupClassGenerator
implements RuleMethodProcessor {
    private final boolean forceCodeBuilding;
    protected ParserClassNode classNode;
    protected RuleMethod method;

    protected GroupClassGenerator(boolean forceCodeBuilding) {
        this.forceCodeBuilding = forceCodeBuilding;
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        this.classNode = Preconditions.checkNotNull(classNode, "classNode");
        this.method = Preconditions.checkNotNull(method, "method");
        for (InstructionGroup group : method.getGroups()) {
            if (!this.appliesTo(group.getRoot())) continue;
            this.loadGroupClass(group);
        }
    }

    protected abstract boolean appliesTo(InstructionGraphNode var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGroupClass(InstructionGroup group) {
        this.createGroupClassType(group);
        String className = group.getGroupClassType().getClassName();
        ClassLoader classLoader = this.classNode.getParentClass().getClassLoader();
        Class<AsmUtils> clazz = AsmUtils.class;
        synchronized (AsmUtils.class) {
            Class<?> groupClass = AsmUtils.findLoadedClass(className, classLoader);
            if (groupClass == null || this.forceCodeBuilding) {
                byte[] groupClassCode = this.generateGroupClassCode(group);
                group.setGroupClassCode(groupClassCode);
                if (groupClass == null) {
                    AsmUtils.loadClass(className, groupClassCode, classLoader);
                }
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    private void createGroupClassType(InstructionGroup group) {
        String s = this.classNode.name;
        int lastSlash = this.classNode.name.lastIndexOf(47);
        String groupName = group.getName();
        String pkg = lastSlash >= 0 ? s.substring(0, lastSlash) : s;
        String groupClassInternalName = pkg + '/' + groupName;
        group.setGroupClassType(Type.getObjectType(groupClassInternalName));
    }

    protected byte[] generateGroupClassCode(InstructionGroup group) {
        ClassWriter classWriter = new ClassWriter(1);
        this.generateClassBasics(group, classWriter);
        GroupClassGenerator.generateFields(group, classWriter);
        this.generateConstructor(classWriter);
        this.generateMethod(group, classWriter);
        return classWriter.toByteArray();
    }

    private void generateClassBasics(InstructionGroup group, ClassWriter cw) {
        cw.visit(50, 4113, group.getGroupClassType().getInternalName(), null, this.getBaseType().getInternalName(), null);
        cw.visitSource(this.classNode.sourceFile, null);
    }

    protected abstract Type getBaseType();

    private static void generateFields(InstructionGroup group, ClassWriter cw) {
        for (FieldNode field : group.getFields()) {
            cw.visitField(4097, field.name, field.desc, null, null);
        }
    }

    private void generateConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, String.class), null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, this.getBaseType().getInternalName(), "<init>", CodegenUtils.sig(Void.TYPE, String.class), false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }

    protected abstract void generateMethod(InstructionGroup var1, ClassWriter var2);

    protected static void insertSetContextCalls(InstructionGroup group, int localVarIx) {
        InsnList instructions = group.getInstructions();
        for (InstructionGraphNode node : group.getNodes()) {
            if (!node.isCallOnContextAware()) continue;
            AbstractInsnNode insn = node.getInstruction();
            if (node.getPredecessors().size() > 1) {
                AbstractInsnNode loadTarget = node.getPredecessors().get(0).getInstruction();
                instructions.insert(loadTarget, new VarInsnNode(58, ++localVarIx));
                instructions.insert(loadTarget, new InsnNode(89));
                instructions.insertBefore(insn, new VarInsnNode(25, localVarIx));
            } else {
                instructions.insertBefore(insn, new InsnNode(89));
            }
            instructions.insertBefore(insn, new VarInsnNode(25, 1));
            MethodInsnNode insnNode = new MethodInsnNode(185, CodegenUtils.p(ContextAware.class), "setContext", CodegenUtils.sig(Void.TYPE, Context.class), true);
            instructions.insertBefore(insn, insnNode);
        }
    }

    protected static void convertXLoads(InstructionGroup group) {
        String owner = group.getGroupClassType().getInternalName();
        for (InstructionGraphNode node : group.getNodes()) {
            if (!node.isXLoad()) continue;
            VarInsnNode insn = (VarInsnNode)node.getInstruction();
            FieldNode field = group.getFields().get(insn.var);
            group.getInstructions().insert((AbstractInsnNode)insn, new FieldInsnNode(180, owner, field.name, field.desc));
            group.getInstructions().set(insn, new VarInsnNode(25, 0));
        }
    }
}

