/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.github.parboiled1.grappa.transform.hash.InstructionGroupHasher;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.process.RuleMethodProcessor;

public final class InstructionGroupPreparer
implements RuleMethodProcessor {
    private RuleMethod method;

    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull(classNode, "classNode");
        Preconditions.checkNotNull(method, "method");
        return method.containsExplicitActions() || method.containsVars();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        this.method = Preconditions.checkNotNull(method, "method");
        for (InstructionGroup group : method.getGroups()) {
            this.extractInstructions(group);
            InstructionGroupPreparer.extractFields(group);
            InstructionGroupHasher.hash(group, classNode.name);
        }
    }

    private void extractInstructions(InstructionGroup group) {
        for (InstructionGraphNode node : group.getNodes()) {
            if (node == group.getRoot()) continue;
            AbstractInsnNode insn = node.getInstruction();
            this.method.instructions.remove(insn);
            group.getInstructions().add(insn);
        }
    }

    private static void extractFields(InstructionGroup group) {
        List<FieldNode> fields = group.getFields();
        for (InstructionGraphNode node : group.getNodes()) {
            int index;
            if (!node.isXLoad()) continue;
            VarInsnNode insn = (VarInsnNode)node.getInstruction();
            for (index = 0; index < fields.size() && fields.get((int)index).access != insn.var; ++index) {
            }
            if (index == fields.size()) {
                Type type = node.getResultValue().getType();
                fields.add(new FieldNode(insn.var, "field$" + index, type.getDescriptor(), null, type));
            }
            insn.var = index;
        }
    }
}

