/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class FilenameComparator
implements Comparator<String> {
    public static final FilenameComparator INSTANCE = new FilenameComparator();
    private static final Set<String> cppHeaderSuffixes = new HashSet<String>(Arrays.asList(".h", ".hxx", ".hpp"));

    private FilenameComparator() {
    }

    @Override
    public int compare(String path1, String path2) {
        if ("/COMMIT_MSG".equals(path1) && "/COMMIT_MSG".equals(path2)) {
            return 0;
        }
        if ("/COMMIT_MSG".equals(path1)) {
            return -1;
        }
        if ("/COMMIT_MSG".equals(path2)) {
            return 1;
        }
        if ("/MERGE_LIST".equals(path1) && "/MERGE_LIST".equals(path2)) {
            return 0;
        }
        if ("/MERGE_LIST".equals(path1)) {
            return -1;
        }
        if ("/MERGE_LIST".equals(path2)) {
            return 1;
        }
        int s1 = path1.lastIndexOf(46);
        int s2 = path2.lastIndexOf(46);
        if (s1 > 0 && s2 > 0 && path1.substring(0, s1).equals(path2.substring(0, s2))) {
            String suffixA = path1.substring(s1);
            String suffixB = path2.substring(s2);
            if (cppHeaderSuffixes.contains(suffixA)) {
                return -1;
            }
            if (cppHeaderSuffixes.contains(suffixB)) {
                return 1;
            }
        }
        return path1.compareTo(path2);
    }
}

