/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics.dropwizard;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.metrics.dropwizard.DropWizardMetricMaker;
import com.google.gerrit.metrics.dropwizard.MetricJson;
import com.google.gerrit.metrics.dropwizard.MetricResource;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.inject.Inject;
import org.kohsuke.args4j.Option;

class GetMetric
implements RestReadView<MetricResource> {
    private final PermissionBackend permissionBackend;
    private final CurrentUser user;
    private final DropWizardMetricMaker metrics;
    @Option(name="--data-only", usage="return only values")
    boolean dataOnly;

    @Inject
    GetMetric(PermissionBackend permissionBackend, CurrentUser user, DropWizardMetricMaker metrics) {
        this.permissionBackend = permissionBackend;
        this.user = user;
        this.metrics = metrics;
    }

    public MetricJson apply(MetricResource resource) throws AuthException, PermissionBackendException {
        this.permissionBackend.user(this.user).check(GlobalPermission.VIEW_CACHES);
        return new MetricJson(resource.getMetric(), this.metrics.getAnnotations(resource.getName()), this.dataOnly);
    }
}

