/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.account.AccountDirectory;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.change.ReviewerSuggestion;
import com.google.gerrit.server.change.SuggestReviewers;
import com.google.gerrit.server.change.SuggestedReviewer;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.mutable.MutableDouble;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewerRecommender {
    private static final Logger log = LoggerFactory.getLogger(ReviewerRecommender.class);
    private static final double BASE_REVIEWER_WEIGHT = 10.0;
    private static final double BASE_OWNER_WEIGHT = 1.0;
    private static final double BASE_COMMENT_WEIGHT = 0.5;
    private static final double[] WEIGHTS = new double[]{10.0, 1.0, 0.5};
    private static final long PLUGIN_QUERY_TIMEOUT = 500L;
    private final ChangeQueryBuilder changeQueryBuilder;
    private final Config config;
    private final DynamicMap<ReviewerSuggestion> reviewerSuggestionPluginMap;
    private final Provider<InternalChangeQuery> queryProvider;
    private final WorkQueue workQueue;
    private final Provider<ReviewDb> dbProvider;
    private final ApprovalsUtil approvalsUtil;

    @Inject
    ReviewerRecommender(ChangeQueryBuilder changeQueryBuilder, DynamicMap<ReviewerSuggestion> reviewerSuggestionPluginMap, Provider<InternalChangeQuery> queryProvider, WorkQueue workQueue, Provider<ReviewDb> dbProvider, ApprovalsUtil approvalsUtil, @GerritServerConfig Config config) {
        EnumSet<AccountDirectory.FillOptions> fillOptions = EnumSet.of(AccountDirectory.FillOptions.SECONDARY_EMAILS);
        fillOptions.addAll(AccountLoader.DETAILED_OPTIONS);
        this.changeQueryBuilder = changeQueryBuilder;
        this.config = config;
        this.queryProvider = queryProvider;
        this.reviewerSuggestionPluginMap = reviewerSuggestionPluginMap;
        this.workQueue = workQueue;
        this.dbProvider = dbProvider;
        this.approvalsUtil = approvalsUtil;
    }

    public List<Account.Id> suggestReviewers(ChangeNotes changeNotes, SuggestReviewers suggestReviewers, ProjectState projectState, List<Account.Id> candidateList) throws OrmException, IOException, ConfigInvalidException {
        String query = suggestReviewers.getQuery();
        double baseWeight = this.config.getInt("addReviewer", "baseWeight", 1);
        Map<Account.Id, MutableDouble> reviewerScores = Strings.isNullOrEmpty(query) ? this.baseRankingForEmptyQuery(baseWeight) : this.baseRankingForCandidateList(candidateList, projectState, baseWeight);
        ArrayList<Callable<Set>> tasks = new ArrayList<Callable<Set>>(this.reviewerSuggestionPluginMap.plugins().size());
        ArrayList<Double> weights = new ArrayList<Double>(this.reviewerSuggestionPluginMap.plugins().size());
        for (DynamicMap.Entry<ReviewerSuggestion> entry : this.reviewerSuggestionPluginMap) {
            tasks.add(() -> ((ReviewerSuggestion)plugin.getProvider().get()).suggestReviewers(projectState.getNameKey(), changeNotes != null ? changeNotes.getChangeId() : null, query, reviewerScores.keySet()));
            String key = entry.getPluginName() + "-" + entry.getExportName();
            String pluginWeight = this.config.getString("addReviewer", key, "weight");
            if (Strings.isNullOrEmpty(pluginWeight)) {
                pluginWeight = "1";
            }
            log.debug("weight for {}: {}", (Object)key, (Object)pluginWeight);
            try {
                weights.add(Double.parseDouble(pluginWeight));
            }
            catch (NumberFormatException e) {
                log.error("Exception while parsing weight for {}", (Object)key, (Object)e);
                weights.add(1.0);
            }
        }
        try {
            List futures = this.workQueue.getDefaultQueue().invokeAll(tasks, 500L, TimeUnit.MILLISECONDS);
            Iterator iterator = weights.iterator();
            for (Future f : futures) {
                double weight = (Double)iterator.next();
                for (SuggestedReviewer s : (Set)f.get()) {
                    if (reviewerScores.containsKey(s.account)) {
                        reviewerScores.get(s.account).add(s.score * weight);
                        continue;
                    }
                    reviewerScores.put(s.account, new MutableDouble(s.score * weight));
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Exception while suggesting reviewers", e);
            return ImmutableList.of();
        }
        if (changeNotes != null) {
            reviewerScores.remove(changeNotes.getChange().getOwner());
            reviewerScores.keySet().removeAll(this.approvalsUtil.getReviewers(this.dbProvider.get(), changeNotes).byState(ReviewerStateInternal.REVIEWER));
        }
        Stream sorted = reviewerScores.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue()));
        List<Account.Id> list = sorted.map(Map.Entry::getKey).collect(Collectors.toList());
        return list;
    }

    private Map<Account.Id, MutableDouble> baseRankingForEmptyQuery(double baseWeight) throws OrmException, IOException, ConfigInvalidException {
        try {
            List<ChangeData> result = this.queryProvider.get().setLimit(25).setRequestedFields(ImmutableSet.of(ChangeField.APPROVAL.getName())).query(this.changeQueryBuilder.owner("self"));
            HashMap<Account.Id, MutableDouble> suggestions = new HashMap<Account.Id, MutableDouble>();
            for (ChangeData cd : result) {
                for (PatchSetApproval approval : cd.currentApprovals()) {
                    Account.Id id = approval.getAccountId();
                    if (suggestions.containsKey(id)) {
                        ((MutableDouble)suggestions.get(id)).add(baseWeight);
                        continue;
                    }
                    suggestions.put(id, new MutableDouble(baseWeight));
                }
            }
            return suggestions;
        }
        catch (QueryParseException e) {
            log.error("Exception while suggesting reviewers", e);
            return ImmutableMap.of();
        }
    }

    private Map<Account.Id, MutableDouble> baseRankingForCandidateList(List<Account.Id> candidates, ProjectState projectState, double baseWeight) throws OrmException, IOException, ConfigInvalidException {
        LinkedHashMap<Account.Id, MutableDouble> reviewers = new LinkedHashMap<Account.Id, MutableDouble>();
        if (candidates.size() == 0) {
            return reviewers;
        }
        ArrayList predicates = new ArrayList();
        for (Account.Id id : candidates) {
            try {
                Predicate<ChangeData> projectQuery = this.changeQueryBuilder.project(projectState.getName());
                List<LabelType> labelTypes = projectState.getLabelTypes().getLabelTypes();
                ArrayList<Predicate<ChangeData>> labelPredicates = new ArrayList<Predicate<ChangeData>>(labelTypes.size());
                for (LabelType type : labelTypes) {
                    labelPredicates.add(this.changeQueryBuilder.label(type.getName() + ",user=" + id));
                }
                Predicate reviewerQuery = Predicate.and(projectQuery, Predicate.or(labelPredicates));
                Predicate ownerQuery = Predicate.and(projectQuery, this.changeQueryBuilder.owner(id.toString()));
                Predicate commentedByQuery = Predicate.and(projectQuery, this.changeQueryBuilder.commentby(id.toString()));
                predicates.add(reviewerQuery);
                predicates.add(ownerQuery);
                predicates.add(commentedByQuery);
                reviewers.put(id, new MutableDouble());
            }
            catch (QueryParseException e) {
                log.error("Exception while suggesting reviewers", e);
            }
        }
        List result = this.queryProvider.get().setLimit(25).setRequestedFields((Set)ImmutableSet.of()).query(predicates);
        Iterator queryResultIterator = result.iterator();
        Iterator reviewersIterator = reviewers.keySet().iterator();
        int i = 0;
        Account.Id currentId = null;
        while (queryResultIterator.hasNext()) {
            List currentResult = queryResultIterator.next();
            if (i % WEIGHTS.length == 0) {
                currentId = (Account.Id)reviewersIterator.next();
            }
            ((MutableDouble)reviewers.get(currentId)).add(WEIGHTS[i % WEIGHTS.length] * baseWeight * (double)currentResult.size());
            ++i;
        }
        return reviewers;
    }
}

