/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.Accounts;
import com.google.gerrit.server.account.Emails;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.query.account.InternalAccountQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class AccountResolver {
    private final Realm realm;
    private final Accounts accounts;
    private final AccountCache byId;
    private final Provider<InternalAccountQuery> accountQueryProvider;
    private final Emails emails;

    @Inject
    AccountResolver(Realm realm, Accounts accounts, AccountCache byId, Provider<InternalAccountQuery> accountQueryProvider, Emails emails) {
        this.realm = realm;
        this.accounts = accounts;
        this.byId = byId;
        this.accountQueryProvider = accountQueryProvider;
        this.emails = emails;
    }

    public Account find(String nameOrEmail) throws OrmException, IOException, ConfigInvalidException {
        Set<Account.Id> r = this.findAll(nameOrEmail);
        if (r.size() == 1) {
            return this.byId.get(r.iterator().next()).getAccount();
        }
        Account match = null;
        for (Account.Id id : r) {
            Account account = this.byId.get(id).getAccount();
            if (!account.isActive()) continue;
            if (match != null) {
                return null;
            }
            match = account;
        }
        return match;
    }

    public Set<Account.Id> findAll(String nameOrEmail) throws OrmException, IOException, ConfigInvalidException {
        AccountState who;
        Matcher m = Pattern.compile("^.* \\(([1-9][0-9]*)\\)$").matcher(nameOrEmail);
        if (m.matches()) {
            Account.Id id = Account.Id.parse(m.group(1));
            if (this.accounts.get(id) != null) {
                return Collections.singleton(id);
            }
            return Collections.emptySet();
        }
        if (nameOrEmail.matches("^[1-9][0-9]*$")) {
            Account.Id id = Account.Id.parse(nameOrEmail);
            if (this.accounts.get(id) != null) {
                return Collections.singleton(id);
            }
            return Collections.emptySet();
        }
        if (ExternalId.isValidUsername(nameOrEmail) && (who = this.byId.getByUsername(nameOrEmail)) != null) {
            return Collections.singleton(who.getAccount().getId());
        }
        return this.findAllByNameOrEmail(nameOrEmail);
    }

    public Account findByNameOrEmail(String nameOrEmail) throws OrmException, IOException {
        Set<Account.Id> r = this.findAllByNameOrEmail(nameOrEmail);
        return r.size() == 1 ? this.byId.get(r.iterator().next()).getAccount() : null;
    }

    public Set<Account.Id> findAllByNameOrEmail(String nameOrEmail) throws OrmException, IOException {
        int lt = nameOrEmail.indexOf(60);
        int gt = nameOrEmail.indexOf(62);
        if (lt >= 0 && gt > lt && nameOrEmail.contains("@")) {
            ImmutableSet<Account.Id> ids = this.emails.getAccountFor(nameOrEmail.substring(lt + 1, gt));
            if (ids.isEmpty() || ids.size() == 1) {
                return ids;
            }
            String name = nameOrEmail.substring(0, lt - 1);
            HashSet<Account.Id> nameMatches = new HashSet<Account.Id>();
            for (Account.Id id : ids) {
                Account a2 = this.byId.get(id).getAccount();
                if (!name.equals(a2.getFullName())) continue;
                nameMatches.add(id);
            }
            return nameMatches.isEmpty() ? ids : nameMatches;
        }
        if (nameOrEmail.contains("@")) {
            return this.emails.getAccountFor(nameOrEmail);
        }
        Account.Id id = this.realm.lookup(nameOrEmail);
        if (id != null) {
            return Collections.singleton(id);
        }
        List<AccountState> m = this.accountQueryProvider.get().byFullName(nameOrEmail);
        if (m.size() == 1) {
            return Collections.singleton(m.get(0).getAccount().getId());
        }
        return this.accountQueryProvider.get().byDefault(nameOrEmail).stream().map(a -> a.getAccount().getId()).collect(Collectors.toSet());
    }
}

