/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.io.ByteSource;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.common.errors.InvalidSshKeyException;
import com.google.gerrit.extensions.common.SshKeyInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RawInput;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetSshKeys;
import com.google.gerrit.server.account.VersionedAuthorizedKeys;
import com.google.gerrit.server.mail.send.AddKeySender;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.ssh.SshKeyCache;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AddSshKey
implements RestModifyView<AccountResource, Input> {
    private static final Logger log = LoggerFactory.getLogger(AddSshKey.class);
    private final Provider<CurrentUser> self;
    private final PermissionBackend permissionBackend;
    private final VersionedAuthorizedKeys.Accessor authorizedKeys;
    private final SshKeyCache sshKeyCache;
    private final AddKeySender.Factory addKeyFactory;

    @Inject
    AddSshKey(Provider<CurrentUser> self, PermissionBackend permissionBackend, VersionedAuthorizedKeys.Accessor authorizedKeys, SshKeyCache sshKeyCache, AddKeySender.Factory addKeyFactory) {
        this.self = self;
        this.permissionBackend = permissionBackend;
        this.authorizedKeys = authorizedKeys;
        this.sshKeyCache = sshKeyCache;
        this.addKeyFactory = addKeyFactory;
    }

    public Response<SshKeyInfo> apply(AccountResource rsrc, Input input) throws AuthException, BadRequestException, OrmException, IOException, ConfigInvalidException, PermissionBackendException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser())) {
            this.permissionBackend.user(this.self).check(GlobalPermission.ADMINISTRATE_SERVER);
        }
        return this.apply(rsrc.getUser(), input);
    }

    public Response<SshKeyInfo> apply(IdentifiedUser user, Input input) throws BadRequestException, IOException, ConfigInvalidException {
        if (input == null) {
            input = new Input();
        }
        if (input.raw == null) {
            throw new BadRequestException("SSH public key missing");
        }
        final RawInput rawKey = input.raw;
        String sshPublicKey = new ByteSource(){

            @Override
            public InputStream openStream() throws IOException {
                return rawKey.getInputStream();
            }
        }.asCharSource(StandardCharsets.UTF_8).read();
        try {
            AccountSshKey sshKey = this.authorizedKeys.addKey(user.getAccountId(), sshPublicKey);
            try {
                this.addKeyFactory.create(user, sshKey).send();
            }
            catch (EmailException e) {
                log.error("Cannot send SSH key added message to " + user.getAccount().getPreferredEmail(), e);
            }
            this.sshKeyCache.evict(user.getUserName());
            return Response.created(GetSshKeys.newSshKeyInfo(sshKey));
        }
        catch (InvalidSshKeyException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    public static class Input {
        public RawInput raw;
    }
}

