/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.extensions.events.TopicEdited;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class PutTopic
extends RetryingRestModifyView<ChangeResource, Input, Response<String>>
implements UiAction<ChangeResource> {
    private final Provider<ReviewDb> dbProvider;
    private final ChangeMessagesUtil cmUtil;
    private final TopicEdited topicEdited;

    @Inject
    PutTopic(Provider<ReviewDb> dbProvider, ChangeMessagesUtil cmUtil, RetryHelper retryHelper, TopicEdited topicEdited) {
        super(retryHelper);
        this.dbProvider = dbProvider;
        this.cmUtil = cmUtil;
        this.topicEdited = topicEdited;
    }

    @Override
    protected Response<String> applyImpl(BatchUpdate.Factory updateFactory, ChangeResource req, Input input) throws UpdateException, RestApiException, PermissionBackendException {
        req.permissions().check(ChangePermission.EDIT_TOPIC_NAME);
        if (input != null && input.topic != null && input.topic.length() > 2048) {
            throw new BadRequestException(String.format("topic length exceeds the limit (%s)", 2048));
        }
        Op op = new Op(input != null ? input : new Input());
        try (BatchUpdate u = updateFactory.create(this.dbProvider.get(), req.getChange().getProject(), req.getUser(), TimeUtil.nowTs());){
            u.addOp(req.getId(), op);
            u.execute();
        }
        return Strings.isNullOrEmpty(op.newTopicName) ? Response.none() : Response.ok(op.newTopicName);
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        return new UiAction.Description().setLabel("Edit Topic").setVisible(rsrc.permissions().testCond(ChangePermission.EDIT_TOPIC_NAME));
    }

    private class Op
    implements BatchUpdateOp {
        private final Input input;
        private Change change;
        private String oldTopicName;
        private String newTopicName;

        Op(Input input) {
            this.input = input;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws OrmException {
            this.change = ctx.getChange();
            ChangeUpdate update = ctx.getUpdate(this.change.currentPatchSetId());
            this.newTopicName = Strings.nullToEmpty(this.input.topic);
            this.oldTopicName = Strings.nullToEmpty(this.change.getTopic());
            if (this.oldTopicName.equals(this.newTopicName)) {
                return false;
            }
            String summary = this.oldTopicName.isEmpty() ? "Topic set to " + this.newTopicName : (this.newTopicName.isEmpty() ? "Topic " + this.oldTopicName + " removed" : String.format("Topic changed from %s to %s", this.oldTopicName, this.newTopicName));
            this.change.setTopic(Strings.emptyToNull(this.newTopicName));
            update.setTopic(this.change.getTopic());
            ChangeMessage cmsg = ChangeMessagesUtil.newMessage(ctx, summary, "autogenerated:gerrit:setTopic");
            PutTopic.this.cmUtil.addChangeMessage(ctx.getDb(), update, cmsg);
            return true;
        }

        @Override
        public void postUpdate(Context ctx) {
            if (this.change != null) {
                PutTopic.this.topicEdited.fire(this.change, ctx.getAccount(), this.oldTopicName, ctx.getWhen());
            }
        }
    }

    public static class Input {
        @DefaultInput
        public String topic;
    }
}

