/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;

public class ConfigUtil {
    private static <T> T[] allValuesOf(T defaultValue) {
        try {
            return (Object[])defaultValue.getClass().getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot obtain enumeration values", e);
        }
    }

    private static <T extends Enum<?>> T getEnum(String section, String subsection, String setting, String valueString, T[] all) {
        String n = valueString.replace(' ', '_').replace('-', '_');
        for (T e : all) {
            if (!((Enum)e).name().equalsIgnoreCase(n)) continue;
            return e;
        }
        StringBuilder r = new StringBuilder();
        r.append("Value \"");
        r.append(valueString);
        r.append("\" not recognized in ");
        r.append(section);
        if (subsection != null) {
            r.append(".");
            r.append(subsection);
        }
        r.append(".");
        r.append(setting);
        r.append("; supported values are: ");
        for (T e : all) {
            r.append(((Enum)e).name());
            r.append(" ");
        }
        throw new IllegalArgumentException(r.toString().trim());
    }

    public static <T extends Enum<?>> List<T> getEnumList(Config config, String section, String subsection, String setting, T defaultValue) {
        Enum[] all = ConfigUtil.allValuesOf(defaultValue);
        return ConfigUtil.getEnumList((Config)config, (String)section, (String)subsection, (String)setting, (Enum[])all, defaultValue);
    }

    public static <T extends Enum<?>> List<T> getEnumList(Config config, String section, String subsection, String setting, T[] all, T defaultValue) {
        ArrayList<Enum> list = new ArrayList<Enum>();
        String[] values = config.getStringList(section, subsection, setting);
        if (values.length == 0) {
            list.add(defaultValue);
        } else {
            for (String string : values) {
                if (string == null) continue;
                list.add(ConfigUtil.getEnum((String)section, (String)subsection, (String)setting, (String)string, all));
            }
        }
        return list;
    }

    public static long getTimeUnit(Config config, String section, String subsection, String setting, long defaultValue, TimeUnit wantUnit) {
        String valueString = config.getString(section, subsection, setting);
        if (valueString == null) {
            return defaultValue;
        }
        String s = valueString.trim();
        if (s.length() == 0) {
            return defaultValue;
        }
        if (s.startsWith("-")) {
            throw ConfigUtil.notTimeUnit(section, subsection, setting, valueString);
        }
        try {
            return ConfigUtil.getTimeUnit(s, defaultValue, wantUnit);
        }
        catch (IllegalArgumentException notTime) {
            throw ConfigUtil.notTimeUnit(section, subsection, setting, valueString);
        }
    }

    public static long getTimeUnit(String valueString, long defaultValue, TimeUnit wantUnit) {
        int inputMul;
        TimeUnit inputUnit;
        Matcher m = Pattern.compile("^(0|[1-9][0-9]*)\\s*(.*)$").matcher(valueString);
        if (!m.matches()) {
            return defaultValue;
        }
        String digits = m.group(1);
        String unitName = m.group(2).trim();
        if ("".equals(unitName)) {
            inputUnit = wantUnit;
            inputMul = 1;
        } else if (ConfigUtil.match(unitName, "ms", "milliseconds")) {
            inputUnit = TimeUnit.MILLISECONDS;
            inputMul = 1;
        } else if (ConfigUtil.match(unitName, "s", "sec", "second", "seconds")) {
            inputUnit = TimeUnit.SECONDS;
            inputMul = 1;
        } else if (ConfigUtil.match(unitName, "m", "min", "minute", "minutes")) {
            inputUnit = TimeUnit.MINUTES;
            inputMul = 1;
        } else if (ConfigUtil.match(unitName, "h", "hr", "hour", "hours")) {
            inputUnit = TimeUnit.HOURS;
            inputMul = 1;
        } else if (ConfigUtil.match(unitName, "d", "day", "days")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 1;
        } else if (ConfigUtil.match(unitName, "w", "week", "weeks")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 7;
        } else if (ConfigUtil.match(unitName, "mon", "month", "months")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 30;
        } else if (ConfigUtil.match(unitName, "y", "year", "years")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 365;
        } else {
            throw ConfigUtil.notTimeUnit(valueString);
        }
        try {
            return wantUnit.convert(Long.parseLong(digits) * (long)inputMul, inputUnit);
        }
        catch (NumberFormatException nfe) {
            throw ConfigUtil.notTimeUnit(valueString);
        }
    }

    public static String getRequired(Config cfg, String section, String name) {
        String v = cfg.getString(section, null, name);
        if (v == null || "".equals(v)) {
            throw new IllegalArgumentException("No " + section + "." + name + " configured");
        }
        return v;
    }

    public static <T> void storeSection(Config cfg, String section, String sub, T s, T defaults) throws ConfigInvalidException {
        try {
            for (Field f : s.getClass().getDeclaredFields()) {
                if (ConfigUtil.skipField(f)) continue;
                Class<?> t = f.getType();
                String n = f.getName();
                f.setAccessible(true);
                Object c = f.get(s);
                Object d = f.get(defaults);
                if (!ConfigUtil.isString(t) && !ConfigUtil.isCollectionOrMap(t)) {
                    Preconditions.checkNotNull(d, "Default cannot be null for: " + n);
                }
                if (c == null || c.equals(d)) {
                    cfg.unset(section, sub, n);
                    continue;
                }
                if (ConfigUtil.isString(t)) {
                    cfg.setString(section, sub, n, (String)c);
                    continue;
                }
                if (ConfigUtil.isInteger(t)) {
                    cfg.setInt(section, sub, n, (Integer)c);
                    continue;
                }
                if (ConfigUtil.isLong(t)) {
                    cfg.setLong(section, sub, n, (Long)c);
                    continue;
                }
                if (ConfigUtil.isBoolean(t)) {
                    cfg.setBoolean(section, sub, n, (Boolean)c);
                    continue;
                }
                if (t.isEnum()) {
                    cfg.setEnum(section, sub, n, (Enum)c);
                    continue;
                }
                if (ConfigUtil.isCollectionOrMap(t)) continue;
                throw new ConfigInvalidException("type is unknown: " + t.getName());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new ConfigInvalidException("cannot save values", e);
        }
    }

    public static <T> T loadSection(Config cfg, String section, String sub, T s, T defaults, T i) throws ConfigInvalidException {
        try {
            for (Field f : s.getClass().getDeclaredFields()) {
                Object o;
                if (ConfigUtil.skipField(f)) continue;
                Class<?> t = f.getType();
                String n = f.getName();
                f.setAccessible(true);
                Object d = f.get(defaults);
                if (!ConfigUtil.isString(t) && !ConfigUtil.isCollectionOrMap(t)) {
                    Preconditions.checkNotNull(d, "Default cannot be null for: " + n);
                }
                if (ConfigUtil.isString(t)) {
                    String v = cfg.getString(section, sub, n);
                    if (v == null) {
                        v = (String)d;
                    }
                    f.set(s, v);
                } else if (ConfigUtil.isInteger(t)) {
                    f.set(s, cfg.getInt(section, sub, n, (Integer)d));
                } else if (ConfigUtil.isLong(t)) {
                    f.set(s, cfg.getLong(section, sub, n, (Long)d));
                } else if (ConfigUtil.isBoolean(t)) {
                    boolean b = cfg.getBoolean(section, sub, n, (Boolean)d);
                    if (b || i != null) {
                        f.set(s, b);
                    }
                } else if (t.isEnum()) {
                    f.set(s, cfg.getEnum(section, sub, n, (Enum)d));
                } else {
                    if (ConfigUtil.isCollectionOrMap(t)) continue;
                    throw new ConfigInvalidException("type is unknown: " + t.getName());
                }
                if (i == null || (o = f.get(i)) == null) continue;
                f.set(s, o);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new ConfigInvalidException("cannot load values", e);
        }
        return s;
    }

    public static boolean skipField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isFinal(modifiers) || Modifier.isTransient(modifiers);
    }

    private static boolean isCollectionOrMap(Class<?> t) {
        return Collection.class.isAssignableFrom(t) || Map.class.isAssignableFrom(t);
    }

    private static boolean isString(Class<?> t) {
        return String.class == t;
    }

    private static boolean isBoolean(Class<?> t) {
        return Boolean.class == t || Boolean.TYPE == t;
    }

    private static boolean isLong(Class<?> t) {
        return Long.class == t || Long.TYPE == t;
    }

    private static boolean isInteger(Class<?> t) {
        return Integer.class == t || Integer.TYPE == t;
    }

    private static boolean match(String a, String ... cases) {
        for (String b : cases) {
            if (b == null || !b.equalsIgnoreCase(a)) continue;
            return true;
        }
        return false;
    }

    private static IllegalArgumentException notTimeUnit(String section, String subsection, String setting, String valueString) {
        return new IllegalArgumentException("Invalid time unit value: " + section + (subsection != null ? "." + subsection : "") + "." + setting + " = " + valueString);
    }

    private static IllegalArgumentException notTimeUnit(String val) {
        return new IllegalArgumentException("Invalid time unit value: " + val);
    }

    private ConfigUtil() {
    }
}

