/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.transport.ReceiveCommand;

public class LockFailureException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final ImmutableList<String> refs;

    public LockFailureException(String message, RefUpdate refUpdate) {
        super(message);
        this.refs = ImmutableList.of(refUpdate.getName());
    }

    public LockFailureException(String message, BatchRefUpdate batchRefUpdate) {
        super(message);
        this.refs = batchRefUpdate.getCommands().stream().filter(c -> c.getResult() == ReceiveCommand.Result.LOCK_FAILURE).map(ReceiveCommand::getRefName).collect(ImmutableList.toImmutableList());
    }

    public ImmutableList<String> getFailedRefs() {
        return this.refs;
    }
}

