/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.receive;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.RefFilter;

class ReceiveRefFilter
implements RefFilter {
    ReceiveRefFilter() {
    }

    @Override
    public Map<String, Ref> filter(Map<String, Ref> refs) {
        HashMap<String, Ref> filteredRefs = Maps.newHashMapWithExpectedSize(refs.size());
        for (Map.Entry<String, Ref> e : refs.entrySet()) {
            String name = e.getKey();
            if (name.startsWith("refs/changes/") || name.startsWith("refs/cache-automerge/")) continue;
            filteredRefs.put(name, e.getValue());
        }
        return filteredRefs;
    }
}

