/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.client.AuthType;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.group.GetMember;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsUpdate;
import com.google.gerrit.server.group.MemberResource;
import com.google.gerrit.server.group.UserInitiated;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class AddMembers
implements RestModifyView<GroupResource, Input> {
    private final AccountManager accountManager;
    private final AuthType authType;
    private final AccountsCollection accounts;
    private final AccountResolver accountResolver;
    private final AccountCache accountCache;
    private final AccountLoader.Factory infoFactory;
    private final Provider<ReviewDb> db;
    private final Provider<GroupsUpdate> groupsUpdateProvider;

    @Inject
    AddMembers(AccountManager accountManager, AuthConfig authConfig, AccountsCollection accounts, AccountResolver accountResolver, AccountCache accountCache, AccountLoader.Factory infoFactory, Provider<ReviewDb> db, @UserInitiated Provider<GroupsUpdate> groupsUpdateProvider) {
        this.accountManager = accountManager;
        this.authType = authConfig.getAuthType();
        this.accounts = accounts;
        this.accountResolver = accountResolver;
        this.accountCache = accountCache;
        this.infoFactory = infoFactory;
        this.db = db;
        this.groupsUpdateProvider = groupsUpdateProvider;
    }

    public List<AccountInfo> apply(GroupResource resource, Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException, IOException, ConfigInvalidException, ResourceNotFoundException {
        GroupDescription.Internal internalGroup = resource.asInternalGroup().orElseThrow(MethodNotAllowedException::new);
        input = Input.init(input);
        GroupControl control = resource.getControl();
        if (!control.canAddMember()) {
            throw new AuthException("Cannot add members to group " + internalGroup.getName());
        }
        HashSet<Account.Id> newMemberIds = new HashSet<Account.Id>();
        for (String nameOrEmailOrId : input.members) {
            Account a = this.findAccount(nameOrEmailOrId);
            if (!a.isActive()) {
                throw new UnprocessableEntityException(String.format("Account Inactive: %s", nameOrEmailOrId));
            }
            newMemberIds.add(a.getId());
        }
        AccountGroup.UUID groupUuid = internalGroup.getGroupUUID();
        try {
            this.addMembers(groupUuid, newMemberIds);
        }
        catch (NoSuchGroupException e) {
            throw new ResourceNotFoundException(String.format("Group %s not found", groupUuid));
        }
        return this.toAccountInfoList(newMemberIds);
    }

    Account findAccount(String nameOrEmailOrId) throws AuthException, UnprocessableEntityException, OrmException, IOException, ConfigInvalidException {
        try {
            return this.accounts.parse(nameOrEmailOrId).getAccount();
        }
        catch (UnprocessableEntityException e) {
            switch (this.authType) {
                case HTTP_LDAP: 
                case CLIENT_SSL_CERT_LDAP: 
                case LDAP: {
                    Account a;
                    if (this.accountResolver.find(nameOrEmailOrId) != null || (a = this.createAccountByLdap(nameOrEmailOrId)) == null) break;
                    return a;
                }
            }
            throw e;
        }
    }

    public void addMembers(AccountGroup.UUID groupUuid, Collection<? extends Account.Id> newMemberIds) throws OrmException, IOException, NoSuchGroupException {
        this.groupsUpdateProvider.get().addGroupMembers(this.db.get(), groupUuid, ImmutableSet.copyOf(newMemberIds));
    }

    private Account createAccountByLdap(String user) throws IOException {
        if (!ExternalId.isValidUsername(user)) {
            return null;
        }
        try {
            AuthRequest req = AuthRequest.forUser(user);
            req.setSkipAuthentication(true);
            return this.accountCache.get(this.accountManager.authenticate(req).getAccountId()).getAccount();
        }
        catch (AccountException e) {
            return null;
        }
    }

    private List<AccountInfo> toAccountInfoList(Set<Account.Id> accountIds) throws OrmException {
        ArrayList<AccountInfo> result = new ArrayList<AccountInfo>();
        AccountLoader loader = this.infoFactory.create(true);
        for (Account.Id accId : accountIds) {
            result.add(loader.get(accId));
        }
        loader.fill();
        return result;
    }

    @Singleton
    static class UpdateMember
    implements RestModifyView<MemberResource, PutMember.Input> {
        private final GetMember get;

        @Inject
        UpdateMember(GetMember get) {
            this.get = get;
        }

        public AccountInfo apply(MemberResource resource, PutMember.Input input) throws OrmException {
            return this.get.apply(resource);
        }
    }

    static class PutMember
    implements RestModifyView<GroupResource, Input> {
        private final AddMembers put;
        private final String id;

        PutMember(AddMembers put, String id) {
            this.put = put;
            this.id = id;
        }

        public AccountInfo apply(GroupResource resource, Input input) throws AuthException, MethodNotAllowedException, ResourceNotFoundException, OrmException, IOException, ConfigInvalidException {
            com.google.gerrit.server.group.AddMembers$Input in = new com.google.gerrit.server.group.AddMembers$Input();
            in._oneMember = this.id;
            try {
                List<AccountInfo> list = this.put.apply(resource, in);
                if (list.size() == 1) {
                    return list.get(0);
                }
                throw new IllegalStateException();
            }
            catch (UnprocessableEntityException e) {
                throw new ResourceNotFoundException(this.id);
            }
        }

        static class Input {
            Input() {
            }
        }
    }

    public static class Input {
        @DefaultInput
        String _oneMember;
        List<String> members;

        public static Input fromMembers(List<String> members) {
            Input in = new Input();
            in.members = members;
            return in;
        }

        static Input init(Input in) {
            if (in == null) {
                in = new Input();
            }
            if (in.members == null) {
                in.members = Lists.newArrayListWithCapacity(1);
            }
            if (!Strings.isNullOrEmpty(in._oneMember)) {
                in.members.add(in._oneMember);
            }
            return in;
        }
    }
}

