/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.group.AddMembers;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.Groups;
import com.google.gerrit.server.group.ListMembers;
import com.google.gerrit.server.group.MemberResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class MembersCollection
implements ChildCollection<GroupResource, MemberResource>,
AcceptsCreate<GroupResource> {
    private final DynamicMap<RestView<MemberResource>> views;
    private final Provider<ListMembers> list;
    private final AccountsCollection accounts;
    private final Groups groups;
    private final Provider<ReviewDb> db;
    private final AddMembers put;

    @Inject
    MembersCollection(DynamicMap<RestView<MemberResource>> views, Provider<ListMembers> list, AccountsCollection accounts, Groups groups, Provider<ReviewDb> db, AddMembers put) {
        this.views = views;
        this.list = list;
        this.accounts = accounts;
        this.groups = groups;
        this.db = db;
        this.put = put;
    }

    @Override
    public RestView<GroupResource> list() throws ResourceNotFoundException, AuthException {
        return this.list.get();
    }

    @Override
    public MemberResource parse(GroupResource parent, IdString id) throws MethodNotAllowedException, AuthException, ResourceNotFoundException, OrmException, IOException, ConfigInvalidException {
        GroupDescription.Internal group = parent.asInternalGroup().orElseThrow(MethodNotAllowedException::new);
        IdentifiedUser user = this.accounts.parse(TopLevelResource.INSTANCE, id).getUser();
        if (parent.getControl().canSeeMember(user.getAccountId()) && this.isMember(group, user)) {
            return new MemberResource(parent, user);
        }
        throw new ResourceNotFoundException(id);
    }

    private boolean isMember(GroupDescription.Internal group, IdentifiedUser user) throws OrmException, ResourceNotFoundException {
        AccountGroup.UUID groupUuid = group.getGroupUUID();
        try {
            return this.groups.isMember(this.db.get(), groupUuid, user.getAccountId());
        }
        catch (NoSuchGroupException e) {
            throw new ResourceNotFoundException(String.format("Group %s not found", groupUuid));
        }
    }

    public AddMembers.PutMember create(GroupResource group, IdString id) {
        return new AddMembers.PutMember(this.put, id.get());
    }

    @Override
    public DynamicMap<RestView<MemberResource>> views() {
        return this.views;
    }
}

