/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.NameAlreadyUsedException;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsUpdate;
import com.google.gerrit.server.group.UserInitiated;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class PutName
implements RestModifyView<GroupResource, Input> {
    private final Provider<ReviewDb> db;
    private final Provider<GroupsUpdate> groupsUpdateProvider;

    @Inject
    PutName(Provider<ReviewDb> db, @UserInitiated Provider<GroupsUpdate> groupsUpdateProvider) {
        this.db = db;
        this.groupsUpdateProvider = groupsUpdateProvider;
    }

    public String apply(GroupResource rsrc, Input input) throws MethodNotAllowedException, AuthException, BadRequestException, ResourceConflictException, ResourceNotFoundException, OrmException, IOException {
        GroupDescription.Internal internalGroup = rsrc.asInternalGroup().orElseThrow(MethodNotAllowedException::new);
        if (!rsrc.getControl().isOwner()) {
            throw new AuthException("Not group owner");
        }
        if (input == null || Strings.isNullOrEmpty(input.name)) {
            throw new BadRequestException("name is required");
        }
        String newName = input.name.trim();
        if (newName.isEmpty()) {
            throw new BadRequestException("name is required");
        }
        if (internalGroup.getName().equals(newName)) {
            return newName;
        }
        this.renameGroup(internalGroup, newName);
        return newName;
    }

    private void renameGroup(GroupDescription.Internal group, String newName) throws ResourceConflictException, ResourceNotFoundException, OrmException, IOException {
        AccountGroup.UUID groupUuid = group.getGroupUUID();
        try {
            this.groupsUpdateProvider.get().renameGroup(this.db.get(), groupUuid, new AccountGroup.NameKey(newName));
        }
        catch (NoSuchGroupException e) {
            throw new ResourceNotFoundException(String.format("Group %s not found", groupUuid));
        }
        catch (NameAlreadyUsedException e) {
            throw new ResourceConflictException("group with name " + newName + " already exists");
        }
    }

    public static class Input {
        @DefaultInput
        public String name;
    }
}

