/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.group;

import com.google.common.base.Preconditions;
import com.google.gerrit.index.IndexRewriter;
import com.google.gerrit.index.QueryOptions;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.index.group.GroupIndex;
import com.google.gerrit.server.index.group.GroupIndexCollection;
import com.google.gerrit.server.index.group.IndexedGroupQuery;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class GroupIndexRewriter
implements IndexRewriter<InternalGroup> {
    private final GroupIndexCollection indexes;

    @Inject
    GroupIndexRewriter(GroupIndexCollection indexes) {
        this.indexes = indexes;
    }

    @Override
    public Predicate<InternalGroup> rewrite(Predicate<InternalGroup> in, QueryOptions opts) throws QueryParseException {
        GroupIndex index = (GroupIndex)this.indexes.getSearchIndex();
        Preconditions.checkNotNull(index, "no active search index configured for groups");
        return new IndexedGroupQuery(index, in, opts);
    }
}

