/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.UserIdentity;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.mail.send.EmailHeader;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.validators.OutgoingEmailValidationListener;
import com.google.gerrit.server.validators.ValidationException;
import com.google.gwtorm.server.OrmException;
import com.google.template.soy.data.SanitizedContent;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OutgoingEmail {
    private static final Logger log = LoggerFactory.getLogger(OutgoingEmail.class);
    private static final String HDR_TO = "To";
    private static final String HDR_CC = "CC";
    protected String messageClass;
    private final HashSet<Account.Id> rcptTo = new HashSet();
    private final Map<String, EmailHeader> headers;
    private final Set<Address> smtpRcptTo = new HashSet<Address>();
    private Address smtpFromAddress;
    private StringBuilder textBody;
    private StringBuilder htmlBody;
    private ListMultimap<RecipientType, Account.Id> accountsToNotify = ImmutableListMultimap.of();
    protected VelocityContext velocityContext;
    protected Map<String, Object> soyContext;
    protected Map<String, Object> soyContextEmailData;
    protected List<String> footers;
    protected final EmailArguments args;
    protected Account.Id fromId;
    protected NotifyHandling notify = NotifyHandling.ALL;

    protected OutgoingEmail(EmailArguments ea, String mc) {
        this.args = ea;
        this.messageClass = mc;
        this.headers = new LinkedHashMap<String, EmailHeader>();
    }

    public void setFrom(Account.Id id) {
        this.fromId = id;
    }

    public void setNotify(NotifyHandling notify) {
        this.notify = Preconditions.checkNotNull(notify);
    }

    public void setAccountsToNotify(ListMultimap<RecipientType, Account.Id> accountsToNotify) {
        this.accountsToNotify = Preconditions.checkNotNull(accountsToNotify);
    }

    public void send() throws EmailException {
        if (!this.args.emailSender.isEnabled()) {
            this.logNotSending(() -> "Email sending is disabled by server config");
            return;
        }
        if (NotifyHandling.NONE.equals((Object)this.notify) && this.accountsToNotify.isEmpty()) {
            this.logNotSending(() -> "Notify handling is NONE");
            return;
        }
        this.init();
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("HeaderHtml"));
        }
        this.format();
        this.appendText(this.textTemplate("Footer"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("FooterHtml"));
        }
        HashSet<Address> smtpRcptToPlaintextOnly = new HashSet<Address>();
        if (this.shouldSendMessage()) {
            if (this.fromId != null) {
                Account fromUser = this.args.accountCache.get(this.fromId).getAccount();
                GeneralPreferencesInfo senderPrefs = fromUser.getGeneralPreferencesInfo();
                if (senderPrefs != null && senderPrefs.getEmailStrategy() == GeneralPreferencesInfo.EmailStrategy.CC_ON_OWN_COMMENTS) {
                    this.add(RecipientType.CC, this.fromId);
                } else if (!this.accountsToNotify.containsValue(this.fromId) && this.rcptTo.remove(this.fromId)) {
                    this.removeUser(fromUser);
                }
            }
            for (Account.Id id : this.rcptTo) {
                Account thisUser = this.args.accountCache.get(id).getAccount();
                GeneralPreferencesInfo prefs = thisUser.getGeneralPreferencesInfo();
                if (prefs == null || prefs.getEmailStrategy() == GeneralPreferencesInfo.EmailStrategy.DISABLED) {
                    this.removeUser(thisUser);
                } else if (this.useHtml() && prefs.getEmailFormat() == GeneralPreferencesInfo.EmailFormat.PLAINTEXT) {
                    this.removeUser(thisUser);
                    smtpRcptToPlaintextOnly.add(new Address(thisUser.getFullName(), thisUser.getPreferredEmail()));
                }
                if (!this.smtpRcptTo.isEmpty() || !smtpRcptToPlaintextOnly.isEmpty()) continue;
                this.logNotSending(() -> "No SMTP recipients");
                return;
            }
            if (!this.headers.containsKey("Reply-To")) {
                Address address;
                StringJoiner j = new StringJoiner(", ");
                if (this.fromId != null && (address = this.toAddress(this.fromId)) != null) {
                    j.add(address.getEmail());
                }
                this.smtpRcptTo.stream().forEach(a -> j.add(a.getEmail()));
                smtpRcptToPlaintextOnly.stream().forEach(a -> j.add(a.getEmail()));
                this.setHeader("Reply-To", j.toString());
            }
            String textPart = this.textBody.toString();
            OutgoingEmailValidationListener.Args va = new OutgoingEmailValidationListener.Args();
            va.messageClass = this.messageClass;
            va.smtpFromAddress = this.smtpFromAddress;
            va.smtpRcptTo = this.smtpRcptTo;
            va.headers = this.headers;
            va.body = textPart;
            va.htmlBody = this.useHtml() ? this.htmlBody.toString() : null;
            for (OutgoingEmailValidationListener validator : this.args.outgoingEmailValidationListeners) {
                try {
                    validator.validateOutgoingEmail(va);
                }
                catch (ValidationException e) {
                    this.logNotSending(() -> String.format("Rejected by outgoing email validator: %s", e.getMessage()));
                    return;
                }
            }
            Sets.SetView<Address> intersection = Sets.intersection(this.smtpRcptTo, smtpRcptToPlaintextOnly);
            if (!intersection.isEmpty()) {
                log.error("Email '{}' will be sent twice to {}", (Object)this.messageClass, (Object)intersection);
            }
            if (!this.smtpRcptTo.isEmpty()) {
                log.debug("Sending multipart '{}'", (Object)this.messageClass);
                this.args.emailSender.send(va.smtpFromAddress, va.smtpRcptTo, va.headers, va.body, va.htmlBody);
            }
            if (!smtpRcptToPlaintextOnly.isEmpty()) {
                log.debug("Sending plaintext '{}'", (Object)this.messageClass);
                HashMap<String, EmailHeader> shallowCopy = new HashMap<String, EmailHeader>();
                shallowCopy.putAll(this.headers);
                shallowCopy.remove(HDR_TO);
                shallowCopy.remove(HDR_CC);
                for (Address a2 : smtpRcptToPlaintextOnly) {
                    EmailHeader.AddressList to = new EmailHeader.AddressList();
                    to.add(a2);
                    shallowCopy.put(HDR_TO, to);
                }
                this.args.emailSender.send(va.smtpFromAddress, smtpRcptToPlaintextOnly, shallowCopy, va.body);
            }
        }
    }

    protected abstract void format() throws EmailException;

    protected void init() throws EmailException {
        this.setupVelocityContext();
        this.setupSoyContext();
        this.smtpFromAddress = this.args.fromAddressGenerator.from(this.fromId);
        this.setHeader("Date", new Date());
        this.headers.put("From", new EmailHeader.AddressList(this.smtpFromAddress));
        this.headers.put(HDR_TO, new EmailHeader.AddressList());
        this.headers.put(HDR_CC, new EmailHeader.AddressList());
        this.setHeader("Message-ID", "");
        for (RecipientType recipientType : this.accountsToNotify.keySet()) {
            this.add(recipientType, this.accountsToNotify.get((Object)recipientType));
        }
        this.setHeader("X-Gerrit-MessageType", this.messageClass);
        this.textBody = new StringBuilder();
        this.htmlBody = new StringBuilder();
        if (this.fromId != null && this.args.fromAddressGenerator.isGenericAddress(this.fromId)) {
            this.appendText(this.getFromLine());
        }
    }

    protected String getFromLine() {
        Account account = this.args.accountCache.get(this.fromId).getAccount();
        String name = account.getFullName();
        String email = account.getPreferredEmail();
        StringBuilder f = new StringBuilder();
        if (name != null && !name.isEmpty() || email != null && !email.isEmpty()) {
            f.append("From");
            if (name != null && !name.isEmpty()) {
                f.append(" ").append(name);
            }
            if (email != null && !email.isEmpty()) {
                f.append(" <").append(email).append(">");
            }
            f.append(":\n\n");
        }
        return f.toString();
    }

    public String getGerritHost() {
        if (this.getGerritUrl() != null) {
            try {
                return new URL(this.getGerritUrl()).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return SystemReader.getInstance().getHostname();
    }

    public String getSettingsUrl() {
        if (this.getGerritUrl() != null) {
            StringBuilder r = new StringBuilder();
            r.append(this.getGerritUrl());
            r.append("settings");
            return r.toString();
        }
        return null;
    }

    public String getGerritUrl() {
        return this.args.urlProvider.get();
    }

    protected void setVHeader(String name, String value) throws EmailException {
        this.setHeader(name, this.velocify(value));
    }

    protected void setHeader(String name, String value) {
        this.headers.put(name, new EmailHeader.String(value));
    }

    protected void removeHeader(String name) {
        this.headers.remove(name);
    }

    protected void setHeader(String name, Date date) {
        this.headers.put(name, new EmailHeader.Date(date));
    }

    protected void appendText(String text) {
        if (text != null) {
            this.textBody.append(text);
        }
    }

    protected void appendHtml(String html) {
        if (html != null) {
            this.htmlBody.append(html);
        }
    }

    protected String getNameFor(@Nullable Account.Id accountId) {
        if (accountId == null) {
            return this.args.gerritPersonIdent.getName();
        }
        return this.args.accountCache.get(accountId).getAccount().getName(this.args.anonymousCowardName);
    }

    protected String getNameEmailFor(@Nullable Account.Id accountId) {
        if (accountId == null) {
            return String.format("%s <%s>", this.args.gerritPersonIdent.getName(), this.args.gerritPersonIdent.getEmailAddress());
        }
        return this.args.accountCache.get(accountId).getAccount().getNameEmail(this.args.anonymousCowardName);
    }

    @Nullable
    protected String getUserNameEmailFor(@Nullable Account.Id accountId) {
        if (accountId == null) {
            return null;
        }
        AccountState who = this.args.accountCache.get(accountId);
        String name = who.getAccount().getFullName();
        String email = who.getAccount().getPreferredEmail();
        if (name != null && email != null) {
            return name + " <" + email + ">";
        }
        if (email != null) {
            return email;
        }
        if (name != null) {
            return name;
        }
        String username = who.getUserName();
        if (username != null) {
            return username;
        }
        return null;
    }

    protected boolean shouldSendMessage() {
        if (this.textBody.length() == 0) {
            this.logNotSending(() -> "No message body");
            return false;
        }
        if (this.smtpRcptTo.isEmpty()) {
            this.logNotSending(() -> "No recipients");
            return false;
        }
        if ((this.accountsToNotify == null || this.accountsToNotify.isEmpty()) && this.smtpRcptTo.size() == 1 && this.rcptTo.size() == 1 && this.rcptTo.contains(this.fromId)) {
            this.logNotSending(() -> "Sender is only recipient");
            return false;
        }
        return true;
    }

    private void logNotSending(Supplier<String> reason) {
        if (log.isDebugEnabled()) {
            log.debug("Not sending '{}': {}", (Object)this.messageClass, (Object)reason.get());
        }
    }

    protected void add(RecipientType rt, Collection<Account.Id> list) {
        this.add(rt, list, false);
    }

    protected void add(RecipientType rt, Collection<Account.Id> list, boolean override) {
        for (Account.Id id : list) {
            this.add(rt, id, override);
        }
    }

    protected void addByEmail(RecipientType rt, Collection<Address> list) {
        this.addByEmail(rt, list, false);
    }

    protected void addByEmail(RecipientType rt, Collection<Address> list, boolean override) {
        for (Address id : list) {
            this.add(rt, id, override);
        }
    }

    protected void add(RecipientType rt, UserIdentity who) {
        this.add(rt, who, false);
    }

    protected void add(RecipientType rt, UserIdentity who, boolean override) {
        if (who != null && who.getAccount() != null) {
            this.add(rt, who.getAccount(), override);
        }
    }

    protected void add(RecipientType rt, Account.Id to) {
        this.add(rt, to, false);
    }

    protected void add(RecipientType rt, Account.Id to, boolean override) {
        try {
            if (!this.rcptTo.contains(to) && this.isVisibleTo(to)) {
                this.rcptTo.add(to);
                this.add(rt, this.toAddress(to), override);
            }
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Error reading database for account: " + to, e);
        }
    }

    protected boolean isVisibleTo(Account.Id to) throws OrmException, PermissionBackendException {
        return true;
    }

    protected void add(RecipientType rt, Address addr) {
        this.add(rt, addr, false);
    }

    protected void add(RecipientType rt, Address addr, boolean override) {
        if (addr != null && addr.getEmail() != null && addr.getEmail().length() > 0) {
            if (!this.args.validator.isValid(addr.getEmail())) {
                log.warn("Not emailing " + addr.getEmail() + " (invalid email address)");
            } else if (!this.args.emailSender.canEmail(addr.getEmail())) {
                log.warn("Not emailing " + addr.getEmail() + " (prohibited by allowrcpt)");
            } else {
                if (!this.smtpRcptTo.add(addr)) {
                    if (!override) {
                        return;
                    }
                    ((EmailHeader.AddressList)this.headers.get(HDR_TO)).remove(addr.getEmail());
                    ((EmailHeader.AddressList)this.headers.get(HDR_CC)).remove(addr.getEmail());
                }
                switch (rt) {
                    case TO: {
                        ((EmailHeader.AddressList)this.headers.get(HDR_TO)).add(addr);
                        break;
                    }
                    case CC: {
                        ((EmailHeader.AddressList)this.headers.get(HDR_CC)).add(addr);
                        break;
                    }
                }
            }
        }
    }

    private Address toAddress(Account.Id id) {
        Account a = this.args.accountCache.get(id).getAccount();
        String e = a.getPreferredEmail();
        if (!a.isActive() || e == null) {
            return null;
        }
        return new Address(a.getFullName(), e);
    }

    protected void setupVelocityContext() {
        this.velocityContext = new VelocityContext();
        this.velocityContext.put("email", this);
        this.velocityContext.put("messageClass", this.messageClass);
        this.velocityContext.put("StringUtils", StringUtils.class);
    }

    protected void setupSoyContext() {
        this.soyContext = new HashMap<String, Object>();
        this.footers = new ArrayList<String>();
        this.soyContext.put("messageClass", this.messageClass);
        this.soyContext.put("footers", this.footers);
        this.soyContextEmailData = new HashMap<String, Object>();
        this.soyContextEmailData.put("settingsUrl", this.getSettingsUrl());
        this.soyContextEmailData.put("gerritHost", this.getGerritHost());
        this.soyContextEmailData.put("gerritUrl", this.getGerritUrl());
        this.soyContext.put("email", this.soyContextEmailData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String velocify(String template) throws EmailException {
        RuntimeInstance runtime = this.args.velocityRuntime;
        String templateName = "OutgoingEmail";
        SimpleNode tree = runtime.parse(new StringReader(template), templateName);
        InternalContextAdapterImpl ica = new InternalContextAdapterImpl(this.velocityContext);
        ica.pushCurrentTemplateName(templateName);
        try {
            tree.init(ica, runtime);
            StringWriter w = new StringWriter();
            tree.render(ica, w);
            String string = w.toString();
            ica.popCurrentTemplateName();
            return string;
        }
        catch (Throwable throwable) {
            try {
                ica.popCurrentTemplateName();
                throw throwable;
            }
            catch (Exception e) {
                throw new EmailException("Cannot format velocity template: " + template, e);
            }
        }
    }

    protected String velocifyFile(String name) throws EmailException {
        try {
            RuntimeInstance runtime = this.args.velocityRuntime;
            if (runtime.getLoaderNameForResource(name) == null) {
                name = "com/google/gerrit/server/mail/" + name;
            }
            Template template = runtime.getTemplate(name, StandardCharsets.UTF_8.name());
            StringWriter w = new StringWriter();
            template.merge(this.velocityContext, w);
            return w.toString();
        }
        catch (Exception e) {
            throw new EmailException("Cannot format velocity template " + name, e);
        }
    }

    private String soyTemplate(String name, SanitizedContent.ContentKind kind) {
        return this.args.soyTofu.newRenderer("com.google.gerrit.server.mail.template." + name).setContentKind(kind).setData(this.soyContext).render();
    }

    protected String soyTextTemplate(String name) {
        return this.soyTemplate(name, SanitizedContent.ContentKind.TEXT);
    }

    protected String soyHtmlTemplate(String name) {
        return this.soyTemplate(name, SanitizedContent.ContentKind.HTML);
    }

    protected String textTemplate(String name) throws EmailException {
        String velocityName = name + ".vm";
        Path filePath = this.args.site.mail_dir.resolve(velocityName);
        if (Files.isRegularFile(filePath, new LinkOption[0])) {
            return this.velocifyFile(velocityName);
        }
        return this.soyTextTemplate(name);
    }

    protected void removeUser(Account user) {
        String fromEmail = user.getPreferredEmail();
        Iterator<Address> j = this.smtpRcptTo.iterator();
        while (j.hasNext()) {
            if (!j.next().getEmail().equals(fromEmail)) continue;
            j.remove();
        }
        for (Map.Entry<String, EmailHeader> entry : this.headers.entrySet()) {
            if (!(entry.getValue() instanceof EmailHeader.AddressList) || entry.getKey().equals("From")) continue;
            ((EmailHeader.AddressList)entry.getValue()).remove(fromEmail);
        }
    }

    protected final boolean useHtml() {
        return this.args.settings.html && this.supportsHtml();
    }

    protected boolean supportsHtml() {
        return false;
    }
}

