/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.io.ByteStreams;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.extensions.webui.JavaScriptPlugin;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.PluginLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class PluginUtil {
    public static List<Path> listPlugins(Path pluginsDir, final String suffix) throws IOException {
        if (pluginsDir == null || !Files.exists(pluginsDir, new LinkOption[0])) {
            return ImmutableList.of();
        }
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                boolean accept;
                String n = entry.getFileName().toString();
                boolean bl = accept = !n.startsWith(".last_") && !n.startsWith(".next_") && Files.isRegularFile(entry, new LinkOption[0]);
                if (!Strings.isNullOrEmpty(suffix)) {
                    accept &= n.endsWith(suffix);
                }
                return accept;
            }
        };
        try (DirectoryStream<Path> files = Files.newDirectoryStream(pluginsDir, (DirectoryStream.Filter<? super Path>)filter);){
            List<Path> list = Ordering.natural().sortedCopy(files);
            return list;
        }
    }

    static List<Path> listPlugins(Path pluginsDir) throws IOException {
        return PluginUtil.listPlugins(pluginsDir, null);
    }

    static Path asTemp(InputStream in, String prefix, String suffix, Path dir) throws IOException {
        Path tmp = Files.createTempFile(dir, prefix, suffix, new FileAttribute[0]);
        boolean keep = false;
        try {
            Path path;
            block10: {
                OutputStream out = Files.newOutputStream(tmp, new OpenOption[0]);
                try {
                    ByteStreams.copy(in, out);
                    keep = true;
                    path = tmp;
                    if (out == null) break block10;
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                out.close();
            }
            return path;
        }
        finally {
            if (!keep) {
                Files.delete(tmp);
            }
        }
    }

    public static String nameOf(Path plugin) {
        return PluginUtil.nameOf(plugin.getFileName().toString());
    }

    static String nameOf(String name) {
        int ext;
        if (name.endsWith(".disabled")) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        return 0 < (ext = name.lastIndexOf(46)) ? name.substring(0, ext) : name;
    }

    static ClassLoader parentFor(Plugin.ApiType type) throws InvalidPluginException {
        switch (type) {
            case EXTENSION: {
                return PluginName.class.getClassLoader();
            }
            case PLUGIN: {
                return PluginLoader.class.getClassLoader();
            }
            case JS: {
                return JavaScriptPlugin.class.getClassLoader();
            }
        }
        throw new InvalidPluginException("Unsupported ApiType " + (Object)((Object)type));
    }
}

