/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.base.MoreObjects;
import com.google.gerrit.extensions.annotations.PluginCanonicalWebUrl;
import com.google.gerrit.extensions.annotations.PluginData;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.server.PluginUser;
import com.google.gerrit.server.plugins.PluginMetricMaker;
import com.google.gerrit.server.plugins.ServerPlugin;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

class ServerPluginInfoModule
extends AbstractModule {
    private final ServerPlugin plugin;
    private final Path dataDir;
    private volatile boolean ready;
    private final MetricMaker serverMetrics;

    ServerPluginInfoModule(ServerPlugin plugin, MetricMaker serverMetrics) {
        this.plugin = plugin;
        this.dataDir = plugin.getDataDir();
        this.serverMetrics = serverMetrics;
    }

    @Override
    protected void configure() {
        this.bind(PluginUser.class).toInstance(this.plugin.getPluginUser());
        this.bind(String.class).annotatedWith(PluginName.class).toInstance(this.plugin.getName());
        this.bind(String.class).annotatedWith(PluginCanonicalWebUrl.class).toInstance(this.plugin.getPluginCanonicalWebUrl());
        this.install(new LifecycleModule(){

            @Override
            public void configure() {
                PluginMetricMaker metrics = new PluginMetricMaker(ServerPluginInfoModule.this.serverMetrics, MoreObjects.firstNonNull(ServerPluginInfoModule.this.plugin.getMetricsPrefix(), String.format("plugins/%s/", ServerPluginInfoModule.this.plugin.getName())));
                this.bind(MetricMaker.class).toInstance(metrics);
                this.listener().toInstance(metrics);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Provides
    @PluginData
    Path getPluginData() {
        if (!this.ready) {
            Path path = this.dataDir;
            synchronized (path) {
                if (!this.ready) {
                    try {
                        Files.createDirectories(this.dataDir, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new ProvisionException(String.format("Cannot create %s for plugin %s", this.dataDir.toAbsolutePath(), this.plugin.getName()), e);
                    }
                    this.ready = true;
                }
            }
        }
        return this.dataDir;
    }

    @Provides
    @PluginData
    File getPluginDataAsFile(@PluginData Path pluginData) {
        return pluginData.toFile();
    }
}

