/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.extensions.api.access.GlobalOrPluginPermission;
import com.google.gerrit.extensions.api.access.PluginPermission;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.PeerDaemonUser;
import com.google.gerrit.server.account.CapabilityCollection;
import com.google.gerrit.server.permissions.FailedPermissionBackend;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

@Singleton
public class DefaultPermissionBackend
extends PermissionBackend {
    private static final CurrentUser.PropertyKey<Boolean> IS_ADMIN = CurrentUser.PropertyKey.create();
    private final ProjectCache projectCache;

    @Inject
    DefaultPermissionBackend(ProjectCache projectCache) {
        this.projectCache = projectCache;
    }

    private CapabilityCollection capabilities() {
        return this.projectCache.getAllProjects().getCapabilityCollection();
    }

    @Override
    public PermissionBackend.WithUser user(CurrentUser user) {
        return new WithUserImpl(Preconditions.checkNotNull(user, "user"));
    }

    private static <T extends GlobalOrPluginPermission> Set<T> newSet(Collection<T> permSet) {
        if (permSet instanceof EnumSet) {
            Object s = ((EnumSet)permSet).clone();
            s.clear();
            return s;
        }
        return Sets.newHashSetWithExpectedSize(permSet.size());
    }

    class WithUserImpl
    extends PermissionBackend.WithUser {
        private final CurrentUser user;
        private Boolean admin;

        WithUserImpl(CurrentUser user) {
            this.user = Preconditions.checkNotNull(user, "user");
        }

        @Override
        public PermissionBackend.ForProject project(Project.NameKey project) {
            try {
                return (PermissionBackend.ForProject)DefaultPermissionBackend.this.projectCache.checkedGet(project, true).controlFor(this.user).asForProject().database(this.db);
            }
            catch (Exception e) {
                Throwable cause = e.getCause() != null ? e.getCause() : e;
                return FailedPermissionBackend.project("project '" + project.get() + "' is unavailable", cause);
            }
        }

        @Override
        public void check(GlobalOrPluginPermission perm) throws AuthException, PermissionBackendException {
            if (!this.can(perm)) {
                throw new AuthException(perm.describeForException() + " not permitted");
            }
        }

        @Override
        public <T extends GlobalOrPluginPermission> Set<T> test(Collection<T> permSet) throws PermissionBackendException {
            Set ok = DefaultPermissionBackend.newSet(permSet);
            for (GlobalOrPluginPermission perm : permSet) {
                if (!this.can(perm)) continue;
                ok.add(perm);
            }
            return ok;
        }

        private boolean can(GlobalOrPluginPermission perm) throws PermissionBackendException {
            if (perm instanceof GlobalPermission) {
                return this.can((GlobalPermission)perm);
            }
            if (perm instanceof PluginPermission) {
                PluginPermission pluginPermission = (PluginPermission)perm;
                return this.has(pluginPermission.permissionName()) || pluginPermission.fallBackToAdmin() && this.isAdmin();
            }
            throw new PermissionBackendException(perm + " unsupported");
        }

        private boolean can(GlobalPermission perm) throws PermissionBackendException {
            switch (perm) {
                case ADMINISTRATE_SERVER: {
                    return this.isAdmin();
                }
                case EMAIL_REVIEWERS: {
                    return this.canEmailReviewers();
                }
                case FLUSH_CACHES: 
                case KILL_TASK: 
                case RUN_GC: 
                case VIEW_CACHES: 
                case VIEW_QUEUE: {
                    return this.has(perm.permissionName()) || this.can(GlobalPermission.MAINTAIN_SERVER);
                }
                case CREATE_ACCOUNT: 
                case CREATE_GROUP: 
                case CREATE_PROJECT: 
                case MAINTAIN_SERVER: 
                case MODIFY_ACCOUNT: 
                case STREAM_EVENTS: 
                case VIEW_ALL_ACCOUNTS: 
                case VIEW_CONNECTIONS: 
                case VIEW_PLUGINS: {
                    return this.has(perm.permissionName()) || this.isAdmin();
                }
                case ACCESS_DATABASE: 
                case RUN_AS: {
                    return this.has(perm.permissionName());
                }
            }
            throw new PermissionBackendException(perm + " unsupported");
        }

        private boolean isAdmin() {
            if (this.admin == null) {
                this.admin = this.computeAdmin();
            }
            return this.admin;
        }

        private Boolean computeAdmin() {
            Boolean r = (Boolean)this.user.get(IS_ADMIN);
            if (r == null) {
                r = this.user.isImpersonating() ? Boolean.valueOf(false) : (this.user instanceof PeerDaemonUser ? Boolean.valueOf(true) : Boolean.valueOf(this.allow(((DefaultPermissionBackend)DefaultPermissionBackend.this).capabilities().administrateServer)));
                this.user.put(IS_ADMIN, r);
            }
            return r;
        }

        private boolean canEmailReviewers() {
            ImmutableList<PermissionRule> email = ((DefaultPermissionBackend)DefaultPermissionBackend.this).capabilities().emailReviewers;
            return this.allow(email) || this.notDenied(email);
        }

        private boolean has(String permissionName) {
            return this.allow(DefaultPermissionBackend.this.capabilities().getPermission(permissionName));
        }

        private boolean allow(Collection<PermissionRule> rules) {
            return this.user.getEffectiveGroups().containsAnyOf(rules.stream().filter(r -> r.getAction() == PermissionRule.Action.ALLOW).map(r -> r.getGroup().getUUID()).collect(Collectors.toSet()));
        }

        private boolean notDenied(Collection<PermissionRule> rules) {
            Set<AccountGroup.UUID> denied = rules.stream().filter(r -> r.getAction() != PermissionRule.Action.ALLOW).map(r -> r.getGroup().getUUID()).collect(Collectors.toSet());
            return denied.isEmpty() || !this.user.getEffectiveGroups().containsAnyOf(denied);
        }
    }
}

