/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.api.projects.ReflogEntryInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.CommonConverters;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.BranchResource;
import com.google.inject.Inject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetReflog
implements RestReadView<BranchResource> {
    private static final Logger log = LoggerFactory.getLogger(GetReflog.class);
    private final GitRepositoryManager repoManager;
    private int limit;
    private Timestamp from;
    private Timestamp to;

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="maximum number of reflog entries to list")
    public GetReflog setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Option(name="--from", metaVar="TIMESTAMP", usage="timestamp from which the reflog entries should be listed (UTC, format: yyyyMMdd_HHmm)")
    public GetReflog setFrom(Timestamp from) {
        this.from = from;
        return this;
    }

    @Option(name="--to", metaVar="TIMESTAMP", usage="timestamp until which the reflog entries should be listed (UTC, format: yyyyMMdd_HHmm)")
    public GetReflog setTo(Timestamp to) {
        this.to = to;
        return this;
    }

    @Inject
    public GetReflog(GitRepositoryManager repoManager) {
        this.repoManager = repoManager;
    }

    public List<ReflogEntryInfo> apply(BranchResource rsrc) throws RestApiException, IOException {
        if (!rsrc.getControl().isOwner()) {
            throw new AuthException("not project owner");
        }
        try (Repository repo = this.repoManager.openRepository(rsrc.getNameKey());){
            List<Object> entries;
            ReflogReader r;
            try {
                r = repo.getReflogReader(rsrc.getRef());
            }
            catch (UnsupportedOperationException e2) {
                String msg = "reflog not supported on repo " + rsrc.getNameKey().get();
                log.error(msg);
                throw new MethodNotAllowedException(msg);
            }
            if (r == null) {
                throw new ResourceNotFoundException(rsrc.getRef());
            }
            if (this.from == null && this.to == null) {
                entries = this.limit > 0 ? r.getReverseEntries(this.limit) : r.getReverseEntries();
            } else {
                entries = this.limit > 0 ? new ArrayList(this.limit) : new ArrayList();
                for (ReflogEntry e3 : r.getReverseEntries()) {
                    Timestamp timestamp = new Timestamp(e3.getWho().getWhen().getTime());
                    if ((this.from == null || this.from.before(timestamp)) && (this.to == null || this.to.after(timestamp))) {
                        entries.add(e3);
                    }
                    if (this.limit <= 0 || entries.size() < this.limit) continue;
                    break;
                }
            }
            List list = Lists.transform(entries, e -> this.newReflogEntryInfo((ReflogEntry)e));
            return list;
        }
    }

    private ReflogEntryInfo newReflogEntryInfo(ReflogEntry e) {
        return new ReflogEntryInfo(e.getOldId().getName(), e.getNewId().getName(), CommonConverters.toGitPerson(e.getWho()), e.getComment());
    }
}

