/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.metrics.Counter0;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.GitReceivePackGroups;
import com.google.gerrit.server.config.GitUploadPackGroups;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.FailedPermissionBackend;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.permissions.RefVisibilityControl;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.CommitsCollection;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.PerRequestProjectControlCache;
import com.google.gerrit.server.project.PermissionCollection;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.project.SectionMatcher;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectControl {
    private static final Logger log = LoggerFactory.getLogger(ProjectControl.class);
    private final Set<AccountGroup.UUID> uploadGroups;
    private final Set<AccountGroup.UUID> receiveGroups;
    private final PermissionBackend.WithUser perm;
    private final CurrentUser user;
    private final ProjectState state;
    private final CommitsCollection commits;
    private final ChangeControl.Factory changeControlFactory;
    private final PermissionCollection.Factory permissionFilter;
    private final RefVisibilityControl refVisibilityControl;
    private final VisibleRefFilter.Factory visibleRefFilterFactory;
    private final GitRepositoryManager gitRepositoryManager;
    private final AllUsersName allUsersName;
    private List<SectionMatcher> allSections;
    private Map<String, RefControl> refControls;
    private Boolean declaredOwner;

    @Inject
    ProjectControl(@GitUploadPackGroups Set<AccountGroup.UUID> uploadGroups, @GitReceivePackGroups Set<AccountGroup.UUID> receiveGroups, PermissionCollection.Factory permissionFilter, CommitsCollection commits, ChangeControl.Factory changeControlFactory, PermissionBackend permissionBackend, RefVisibilityControl refVisibilityControl, GitRepositoryManager gitRepositoryManager, VisibleRefFilter.Factory visibleRefFilterFactory, AllUsersName allUsersName, @Assisted CurrentUser who, @Assisted ProjectState ps) {
        this.changeControlFactory = changeControlFactory;
        this.uploadGroups = uploadGroups;
        this.receiveGroups = receiveGroups;
        this.permissionFilter = permissionFilter;
        this.commits = commits;
        this.perm = permissionBackend.user(who);
        this.refVisibilityControl = refVisibilityControl;
        this.gitRepositoryManager = gitRepositoryManager;
        this.visibleRefFilterFactory = visibleRefFilterFactory;
        this.allUsersName = allUsersName;
        this.user = who;
        this.state = ps;
    }

    public ProjectControl forUser(CurrentUser who) {
        ProjectControl r = this.state.controlFor(who);
        r.allSections = this.allSections;
        return r;
    }

    public ChangeControl controlFor(ReviewDb db, Change change) throws OrmException {
        return this.changeControlFactory.create(this.controlForRef(change.getDest()), db, change.getProject(), change.getId());
    }

    public ChangeControl controlFor(ChangeNotes notes) {
        return this.changeControlFactory.create(this.controlForRef(notes.getChange().getDest()), notes);
    }

    public RefControl controlForRef(Branch.NameKey ref) {
        return this.controlForRef(ref.get());
    }

    public RefControl controlForRef(String refName) {
        RefControl ctl;
        if (this.refControls == null) {
            this.refControls = new HashMap<String, RefControl>();
        }
        if ((ctl = this.refControls.get(refName)) == null) {
            PermissionCollection relevant = this.permissionFilter.filter(this.access(), refName, this.user);
            ctl = new RefControl(this.visibleRefFilterFactory, this.refVisibilityControl, this, this.gitRepositoryManager, refName, relevant);
            this.refControls.put(refName, ctl);
        }
        return ctl;
    }

    public CurrentUser getUser() {
        return this.user;
    }

    public ProjectState getProjectState() {
        return this.state;
    }

    public Project getProject() {
        return this.state.getProject();
    }

    public boolean isOwner() {
        return this.isDeclaredOwner() && !this.controlForRef("refs/*").isBlocked("owner") || this.isAdmin();
    }

    public Capable canPushToAtLeastOneRef() {
        if (!(this.canPerformOnAnyRef("push") || this.canPerformOnAnyRef("createTag") || this.isOwner())) {
            return new Capable("Upload denied for project '" + this.state.getName() + "'");
        }
        return Capable.OK;
    }

    private boolean canRunUploadPack() {
        for (AccountGroup.UUID group : this.uploadGroups) {
            if (!this.match(group)) continue;
            return true;
        }
        return false;
    }

    private boolean canRunReceivePack() {
        for (AccountGroup.UUID group : this.receiveGroups) {
            if (!this.match(group)) continue;
            return true;
        }
        return false;
    }

    private boolean allRefsAreVisible(Set<String> ignore) {
        return this.user.isInternalUser() || !this.getProject().getNameKey().equals(this.allUsersName) && this.canPerformOnAllRefs("read", ignore);
    }

    private boolean isHidden() {
        return this.getProject().getState().equals((Object)com.google.gerrit.extensions.client.ProjectState.HIDDEN);
    }

    private boolean canAddRefs() {
        return this.canPerformOnAnyRef("create") || this.isAdmin();
    }

    private boolean canAddTagRefs() {
        return this.canPerformOnTagRef("create") || this.isAdmin();
    }

    private boolean canCreateChanges() {
        for (SectionMatcher matcher : this.access()) {
            Permission permission;
            AccessSection section = matcher.section;
            if (!section.getName().startsWith("refs/for/") && !section.getName().startsWith("^refs/for/") || (permission = section.getPermission("push")) == null || !this.controlForRef(section.getName()).canPerform("push")) continue;
            return true;
        }
        return false;
    }

    boolean isAdmin() {
        try {
            this.perm.check(GlobalPermission.ADMINISTRATE_SERVER);
            return true;
        }
        catch (AuthException | PermissionBackendException e) {
            return false;
        }
    }

    private boolean isDeclaredOwner() {
        if (this.declaredOwner == null) {
            GroupMembership effectiveGroups = this.user.getEffectiveGroups();
            this.declaredOwner = effectiveGroups.containsAnyOf(this.state.getAllOwners());
        }
        return this.declaredOwner;
    }

    private boolean canPerformOnTagRef(String permissionName) {
        for (SectionMatcher matcher : this.access()) {
            Boolean can;
            Permission permission;
            AccessSection section = matcher.section;
            if (!section.getName().startsWith("refs/tags/") && !section.getName().startsWith("^refs/tags/") || (permission = section.getPermission(permissionName)) == null || (can = this.canPerform(permissionName, section, permission)) == null) continue;
            return can;
        }
        return false;
    }

    private boolean canPerformOnAnyRef(String permissionName) {
        for (SectionMatcher matcher : this.access()) {
            Boolean can;
            AccessSection section = matcher.section;
            Permission permission = section.getPermission(permissionName);
            if (permission == null || (can = this.canPerform(permissionName, section, permission)) == null) continue;
            return can;
        }
        return false;
    }

    private Boolean canPerform(String permissionName, AccessSection section, Permission permission) {
        for (PermissionRule rule : permission.getRules()) {
            if (rule.isBlock() || rule.isDeny() || !this.match(rule)) continue;
            if (!this.controlForRef(section.getName()).canPerform(permissionName)) break;
            return true;
        }
        return null;
    }

    private boolean canPerformOnAllRefs(String permission, Set<String> ignore) {
        boolean canPerform = false;
        Set<String> patterns = this.allRefPatterns(permission);
        if (patterns.contains("refs/*")) {
            for (String pattern : patterns) {
                if (this.controlForRef(pattern).canPerform(permission)) {
                    canPerform = true;
                    continue;
                }
                if (ignore.contains(pattern)) continue;
                return false;
            }
        }
        return canPerform;
    }

    private Set<String> allRefPatterns(String permissionName) {
        HashSet<String> all = new HashSet<String>();
        for (SectionMatcher matcher : this.access()) {
            AccessSection section = matcher.section;
            Permission permission = section.getPermission(permissionName);
            if (permission == null) continue;
            all.add(section.getName());
        }
        return all;
    }

    private List<SectionMatcher> access() {
        if (this.allSections == null) {
            this.allSections = this.state.getAllSections();
        }
        return this.allSections;
    }

    boolean match(PermissionRule rule) {
        return this.match(rule.getGroup().getUUID());
    }

    boolean match(PermissionRule rule, boolean isChangeOwner) {
        return this.match(rule.getGroup().getUUID(), isChangeOwner);
    }

    boolean match(AccountGroup.UUID uuid) {
        return this.match(uuid, false);
    }

    boolean match(AccountGroup.UUID uuid, boolean isChangeOwner) {
        if (SystemGroupBackend.PROJECT_OWNERS.equals(uuid)) {
            return this.isDeclaredOwner();
        }
        if (SystemGroupBackend.CHANGE_OWNER.equals(uuid)) {
            return isChangeOwner;
        }
        return this.user.getEffectiveGroups().contains(uuid);
    }

    boolean isReachableFromHeadsOrTags(Repository repo, RevCommit commit) {
        try {
            RefDatabase refdb = repo.getRefDatabase();
            Collection<Ref> heads = refdb.getRefs("refs/heads/").values();
            Collection<Ref> tags = refdb.getRefs("refs/tags/").values();
            HashMap<String, Ref> refs = Maps.newHashMapWithExpectedSize(heads.size() + tags.size());
            for (Ref r : Iterables.concat(heads, tags)) {
                refs.put(r.getName(), r);
            }
            return this.commits.isReachableFrom(this.state, repo, commit, refs);
        }
        catch (IOException e) {
            log.error("Cannot verify permissions to commit object {} in repository {}", commit.name(), this.getProject().getNameKey(), e);
            return false;
        }
    }

    public PermissionBackend.ForProject asForProject() {
        return new ForProjectImpl();
    }

    public class ForProjectImpl
    extends PermissionBackend.ForProject {
        @Override
        public PermissionBackend.ForProject user(CurrentUser user) {
            return (PermissionBackend.ForProject)ProjectControl.this.forUser(user).asForProject().database(this.db);
        }

        @Override
        public PermissionBackend.ForRef ref(String ref) {
            return (PermissionBackend.ForRef)ProjectControl.this.controlForRef(ref).asForRef().database(this.db);
        }

        @Override
        public PermissionBackend.ForChange change(ChangeData cd) {
            try {
                this.checkProject(cd.change());
                return super.change(cd);
            }
            catch (OrmException e) {
                return FailedPermissionBackend.change("unavailable", e);
            }
        }

        @Override
        public PermissionBackend.ForChange change(ChangeNotes notes) {
            this.checkProject(notes.getChange());
            return super.change(notes);
        }

        private void checkProject(Change change) {
            Project.NameKey project = ProjectControl.this.getProject().getNameKey();
            Preconditions.checkArgument(project.equals(change.getProject()), "expected change in project %s, not %s", (Object)project, (Object)change.getProject());
        }

        @Override
        public void check(ProjectPermission perm) throws AuthException, PermissionBackendException {
            if (!this.can(perm)) {
                throw new AuthException(perm.describeForException() + " not permitted");
            }
        }

        @Override
        public Set<ProjectPermission> test(Collection<ProjectPermission> permSet) throws PermissionBackendException {
            EnumSet<ProjectPermission> ok = EnumSet.noneOf(ProjectPermission.class);
            for (ProjectPermission perm : permSet) {
                if (!this.can(perm)) continue;
                ok.add(perm);
            }
            return ok;
        }

        private boolean can(ProjectPermission perm) throws PermissionBackendException {
            switch (perm) {
                case ACCESS: {
                    return !ProjectControl.this.isHidden() && (ProjectControl.this.user.isInternalUser() || ProjectControl.this.canPerformOnAnyRef("read")) || ProjectControl.this.isOwner();
                }
                case READ: {
                    return !ProjectControl.this.isHidden() && ProjectControl.this.allRefsAreVisible(Collections.emptySet());
                }
                case READ_NO_CONFIG: {
                    return !ProjectControl.this.isHidden() && ProjectControl.this.allRefsAreVisible(ImmutableSet.of("refs/meta/config"));
                }
                case CREATE_REF: {
                    return ProjectControl.this.canAddRefs();
                }
                case CREATE_TAG_REF: {
                    return ProjectControl.this.canAddTagRefs();
                }
                case CREATE_CHANGE: {
                    return ProjectControl.this.canCreateChanges();
                }
                case RUN_RECEIVE_PACK: {
                    return ProjectControl.this.canRunReceivePack();
                }
                case RUN_UPLOAD_PACK: {
                    return ProjectControl.this.canRunUploadPack();
                }
            }
            throw new PermissionBackendException((Object)((Object)perm) + " unsupported");
        }
    }

    @Singleton
    protected static class Metrics {
        final Counter0 claCheckCount;

        @Inject
        Metrics(MetricMaker metricMaker) {
            this.claCheckCount = metricMaker.newCounter("license/cla_check_count", new Description("Total number of CLA check requests").setRate().setUnit("requests"));
        }
    }

    public static interface AssistedFactory {
        public ProjectControl create(CurrentUser var1, ProjectState var2);
    }

    public static class Factory {
        private final Provider<PerRequestProjectControlCache> userCache;

        @Inject
        Factory(Provider<PerRequestProjectControlCache> uc) {
            this.userCache = uc;
        }

        public ProjectControl controlFor(Project.NameKey nameKey) throws NoSuchProjectException {
            return this.userCache.get().get(nameKey);
        }
    }

    public static class GenericFactory {
        private final ProjectCache projectCache;

        @Inject
        GenericFactory(ProjectCache pc) {
            this.projectCache = pc;
        }

        public ProjectControl controlFor(Project.NameKey nameKey, CurrentUser user) throws NoSuchProjectException, IOException {
            ProjectState p = this.projectCache.checkedGet(nameKey);
            if (p == null) {
                throw new NoSuchProjectException(nameKey);
            }
            return p.controlFor(user);
        }
    }
}

