/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.FailedPermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.permissions.RefVisibilityControl;
import com.google.gerrit.server.project.PermissionCollection;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectRef;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.util.Providers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class RefControl {
    private final VisibleRefFilter.Factory visibleRefFilterFactory;
    private final RefVisibilityControl refVisibilityControl;
    private final ProjectControl projectControl;
    private final GitRepositoryManager repositoryManager;
    private final String refName;
    private final PermissionCollection relevant;
    private final Map<String, List<PermissionRule>> effective;
    private Boolean owner;
    private Boolean canForgeAuthor;
    private Boolean canForgeCommitter;
    private Boolean hasReadPermissionOnRef;

    RefControl(VisibleRefFilter.Factory visibleRefFilterFactory, RefVisibilityControl refVisibilityControl, ProjectControl projectControl, GitRepositoryManager repositoryManager, String ref, PermissionCollection relevant) {
        this.visibleRefFilterFactory = visibleRefFilterFactory;
        this.refVisibilityControl = refVisibilityControl;
        this.projectControl = projectControl;
        this.repositoryManager = repositoryManager;
        this.refName = ref;
        this.relevant = relevant;
        this.effective = new HashMap<String, List<PermissionRule>>();
    }

    public String getRefName() {
        return this.refName;
    }

    public ProjectControl getProjectControl() {
        return this.projectControl;
    }

    public CurrentUser getUser() {
        return this.projectControl.getUser();
    }

    public RefControl forUser(CurrentUser who) {
        ProjectControl newCtl = this.projectControl.forUser(who);
        if (this.relevant.isUserSpecific()) {
            return newCtl.controlForRef(this.getRefName());
        }
        return new RefControl(this.visibleRefFilterFactory, this.refVisibilityControl, newCtl, this.repositoryManager, this.getRefName(), this.relevant);
    }

    public boolean isOwner() {
        if (this.owner == null) {
            this.owner = this.canPerform("owner") ? Boolean.valueOf(true) : Boolean.valueOf(this.projectControl.isOwner());
        }
        return this.owner;
    }

    public boolean hasReadPermissionOnRef(boolean allowNoteDbRefs) {
        if (!allowNoteDbRefs && (this.refName.startsWith("refs/tags/") || RefNames.isGerritRef(this.refName))) {
            return false;
        }
        if (this.hasReadPermissionOnRef == null) {
            this.hasReadPermissionOnRef = (this.getUser().isInternalUser() || this.canPerform("read")) && this.isProjectStatePermittingRead();
        }
        return this.hasReadPermissionOnRef;
    }

    public boolean isEditVisible() {
        return this.canViewPrivateChanges();
    }

    private boolean canUpload() {
        return this.projectControl.controlForRef("refs/for/" + this.getRefName()).canPerform("push") && this.isProjectStatePermittingWrite();
    }

    boolean canAddPatchSet() {
        return this.projectControl.controlForRef("refs/for/" + this.getRefName()).canPerform("addPatchSet") && this.isProjectStatePermittingWrite();
    }

    private boolean canUploadMerges() {
        return this.projectControl.controlForRef("refs/for/" + this.getRefName()).canPerform("pushMerge") && this.isProjectStatePermittingWrite();
    }

    boolean canRebase() {
        return this.canPerform("rebase") && this.isProjectStatePermittingWrite();
    }

    boolean canSubmit(boolean isChangeOwner) {
        if ("refs/meta/config".equals(this.refName)) {
            return this.projectControl.isOwner();
        }
        return this.canPerform("submit", isChangeOwner) && this.isProjectStatePermittingWrite();
    }

    private boolean canUpdate() {
        if (!(!"refs/meta/config".equals(this.refName) || this.projectControl.isOwner() || this.projectControl.getProjectState().isAllProjects() && this.projectControl.isAdmin())) {
            return false;
        }
        return this.canPerform("push") && this.isProjectStatePermittingWrite();
    }

    private boolean canForceUpdate() {
        if (!this.isProjectStatePermittingWrite()) {
            return false;
        }
        if (this.canPushWithForce()) {
            return true;
        }
        switch (this.getUser().getAccessPath()) {
            case GIT: {
                return false;
            }
        }
        return this.isOwner() && !this.isForceBlocked("push") || this.projectControl.isAdmin();
    }

    private boolean isProjectStatePermittingWrite() {
        return this.getProjectControl().getProject().getState().permitsWrite();
    }

    private boolean isProjectStatePermittingRead() {
        return this.getProjectControl().getProject().getState().permitsRead();
    }

    private boolean canPushWithForce() {
        if (!this.isProjectStatePermittingWrite() || "refs/meta/config".equals(this.refName) && !this.projectControl.isOwner()) {
            return false;
        }
        return this.canForcePerform("push");
    }

    private boolean canDelete() {
        if (!this.isProjectStatePermittingWrite() || "refs/meta/config".equals(this.refName)) {
            return false;
        }
        switch (this.getUser().getAccessPath()) {
            case GIT: {
                return this.canPushWithForce() || this.canPerform("delete");
            }
        }
        return this.isOwner() && !this.isForceBlocked("push") || this.canPushWithForce() || this.canPerform("delete") || this.projectControl.isAdmin();
    }

    private boolean canForgeAuthor() {
        if (this.canForgeAuthor == null) {
            this.canForgeAuthor = this.canPerform("forgeAuthor");
        }
        return this.canForgeAuthor;
    }

    private boolean canForgeCommitter() {
        if (this.canForgeCommitter == null) {
            this.canForgeCommitter = this.canPerform("forgeCommitter");
        }
        return this.canForgeCommitter;
    }

    private boolean canForgeGerritServerIdentity() {
        return this.canPerform("forgeServerAsCommitter");
    }

    boolean canAbandon() {
        return this.canPerform("abandon");
    }

    boolean canRemoveReviewer() {
        return this.canPerform("removeReviewer");
    }

    boolean canViewPrivateChanges() {
        return this.canPerform("viewPrivateChanges");
    }

    boolean canDeleteChanges(boolean isChangeOwner) {
        return this.canPerform("deleteChanges") || isChangeOwner && this.canPerform("deleteOwnChanges", isChangeOwner);
    }

    boolean canEditTopicName() {
        return this.canPerform("editTopicName");
    }

    boolean canEditHashtags() {
        return this.canPerform("editHashtags");
    }

    boolean canEditAssignee() {
        return this.canPerform("editAssignee");
    }

    boolean canForceEditTopicName() {
        return this.canForcePerform("editTopicName");
    }

    PermissionRange getRange(String permission) {
        return this.getRange(permission, false);
    }

    PermissionRange getRange(String permission, boolean isChangeOwner) {
        if (Permission.hasRange(permission)) {
            return this.toRange(permission, this.access(permission, isChangeOwner));
        }
        return null;
    }

    private PermissionRange toRange(String permissionName, List<PermissionRule> ruleList) {
        HashMap<ProjectRef, AllowedRange> ranges = new HashMap<ProjectRef, AllowedRange>();
        for (PermissionRule rule : ruleList) {
            ProjectRef p = this.relevant.getRuleProps(rule);
            AllowedRange r = (AllowedRange)ranges.get(p);
            if (r == null) {
                r = new AllowedRange();
                ranges.put(p, r);
            }
            r.update(rule);
        }
        int allowMin = 0;
        int allowMax = 0;
        int blockMin = Integer.MIN_VALUE;
        int blockMax = Integer.MAX_VALUE;
        for (AllowedRange r : ranges.values()) {
            allowMin = Math.min(allowMin, r.getAllowMin());
            allowMax = Math.max(allowMax, r.getAllowMax());
            blockMin = Math.max(blockMin, r.getBlockMin());
            blockMax = Math.min(blockMax, r.getBlockMax());
        }
        int min = Math.max(allowMin, blockMin + 1);
        int max = Math.min(allowMax, blockMax - 1);
        return new PermissionRange(permissionName, min, max);
    }

    boolean canPerform(String permissionName) {
        return this.canPerform(permissionName, false);
    }

    boolean canPerform(String permissionName, boolean isChangeOwner) {
        return this.doCanPerform(permissionName, isChangeOwner, false);
    }

    public boolean isBlocked(String permissionName) {
        return !this.doCanPerform(permissionName, false, true);
    }

    private boolean doCanPerform(String permissionName, boolean isChangeOwner, boolean blockOnly) {
        List<PermissionRule> access = this.access(permissionName, isChangeOwner);
        List<PermissionRule> overridden = this.relevant.getOverridden(permissionName);
        HashSet<ProjectRef> allows = new HashSet<ProjectRef>();
        HashSet<ProjectRef> blocks = new HashSet<ProjectRef>();
        for (PermissionRule rule : access) {
            if (rule.isBlock() && !rule.getForce().booleanValue()) {
                blocks.add(this.relevant.getRuleProps(rule));
                continue;
            }
            allows.add(this.relevant.getRuleProps(rule));
        }
        for (PermissionRule rule : overridden) {
            blocks.remove(this.relevant.getRuleProps(rule));
        }
        blocks.removeAll(allows);
        return blocks.isEmpty() && (!allows.isEmpty() || blockOnly);
    }

    private boolean canForcePerform(String permissionName) {
        List<PermissionRule> access = this.access(permissionName);
        List<PermissionRule> overridden = this.relevant.getOverridden(permissionName);
        HashSet<ProjectRef> allows = new HashSet<ProjectRef>();
        HashSet<ProjectRef> blocks = new HashSet<ProjectRef>();
        for (PermissionRule rule : access) {
            if (rule.isBlock()) {
                blocks.add(this.relevant.getRuleProps(rule));
                continue;
            }
            if (!rule.getForce().booleanValue()) continue;
            allows.add(this.relevant.getRuleProps(rule));
        }
        for (PermissionRule rule : overridden) {
            if (!rule.getForce().booleanValue()) continue;
            blocks.remove(this.relevant.getRuleProps(rule));
        }
        blocks.removeAll(allows);
        return blocks.isEmpty() && !allows.isEmpty();
    }

    private boolean isForceBlocked(String permissionName) {
        List<PermissionRule> access = this.access(permissionName);
        List<PermissionRule> overridden = this.relevant.getOverridden(permissionName);
        HashSet<ProjectRef> allows = new HashSet<ProjectRef>();
        HashSet<ProjectRef> blocks = new HashSet<ProjectRef>();
        for (PermissionRule rule : access) {
            if (rule.isBlock()) {
                blocks.add(this.relevant.getRuleProps(rule));
                continue;
            }
            if (!rule.getForce().booleanValue()) continue;
            allows.add(this.relevant.getRuleProps(rule));
        }
        for (PermissionRule rule : overridden) {
            if (!rule.getForce().booleanValue()) continue;
            blocks.remove(this.relevant.getRuleProps(rule));
        }
        blocks.removeAll(allows);
        return !blocks.isEmpty();
    }

    private List<PermissionRule> access(String permissionName) {
        return this.access(permissionName, false);
    }

    private List<PermissionRule> access(String permissionName, boolean isChangeOwner) {
        List<PermissionRule> rules = this.effective.get(permissionName);
        if (rules != null) {
            return rules;
        }
        rules = this.relevant.getPermission(permissionName);
        ArrayList<PermissionRule> mine = new ArrayList(rules.size());
        for (PermissionRule rule : rules) {
            if (!this.projectControl.match(rule, isChangeOwner)) continue;
            mine.add(rule);
        }
        if (mine.isEmpty()) {
            mine = Collections.emptyList();
        }
        this.effective.put(permissionName, mine);
        return mine;
    }

    PermissionBackend.ForRef asForRef() {
        return new ForRefImpl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTagVisible() throws PermissionBackendException {
        if (this.projectControl.asForProject().test(ProjectPermission.READ)) {
            return true;
        }
        try (Repository repo = this.repositoryManager.openRepository(this.projectControl.getProject().getNameKey());){
            Ref resolvedRef = repo.getRefDatabase().exactRef(this.refName);
            if (resolvedRef == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.visibleRefFilterFactory.create(this.projectControl.getProjectState(), repo).filter(ImmutableMap.of(resolvedRef.getName(), resolvedRef), true).values().stream().anyMatch(r -> this.refName.equals(r.getName()));
            return bl;
        }
        catch (IOException e) {
            throw new PermissionBackendException(e);
        }
    }

    private class ForRefImpl
    extends PermissionBackend.ForRef {
        private ForRefImpl() {
        }

        @Override
        public PermissionBackend.ForRef user(CurrentUser user) {
            return (PermissionBackend.ForRef)RefControl.this.forUser(user).asForRef().database(this.db);
        }

        @Override
        public PermissionBackend.ForChange change(ChangeData cd) {
            try {
                return RefControl.this.getProjectControl().controlFor(cd.db(), cd.change()).asForChange(cd, Providers.of(cd.db()));
            }
            catch (OrmException e) {
                return FailedPermissionBackend.change("unavailable", e);
            }
        }

        @Override
        public PermissionBackend.ForChange change(ChangeNotes notes) {
            Project.NameKey project = RefControl.this.getProjectControl().getProject().getNameKey();
            Change change = notes.getChange();
            Preconditions.checkArgument(project.equals(change.getProject()), "expected change in project %s, not %s", (Object)project, (Object)change.getProject());
            return RefControl.this.getProjectControl().controlFor(notes).asForChange(null, this.db);
        }

        @Override
        public PermissionBackend.ForChange indexedChange(ChangeData cd, ChangeNotes notes) {
            return RefControl.this.getProjectControl().controlFor(notes).asForChange(cd, this.db);
        }

        @Override
        public void check(RefPermission perm) throws AuthException, PermissionBackendException {
            if (!this.can(perm)) {
                throw new AuthException(perm.describeForException() + " not permitted for " + RefControl.this.getRefName());
            }
        }

        @Override
        public Set<RefPermission> test(Collection<RefPermission> permSet) throws PermissionBackendException {
            EnumSet<RefPermission> ok = EnumSet.noneOf(RefPermission.class);
            for (RefPermission perm : permSet) {
                if (!this.can(perm)) continue;
                ok.add(perm);
            }
            return ok;
        }

        private boolean can(RefPermission perm) throws PermissionBackendException {
            switch (perm) {
                case READ: {
                    if (RefControl.this.getUser().isInternalUser()) {
                        return true;
                    }
                    if (RefControl.this.refName.startsWith("refs/tags/")) {
                        return RefControl.this.isTagVisible();
                    }
                    return RefControl.this.refVisibilityControl.isVisible(RefControl.this.projectControl, RefControl.this.refName);
                }
                case CREATE: {
                    return RefControl.this.canPerform(perm.permissionName().get());
                }
                case DELETE: {
                    return RefControl.this.canDelete();
                }
                case UPDATE: {
                    return RefControl.this.canUpdate();
                }
                case FORCE_UPDATE: {
                    return RefControl.this.canForceUpdate();
                }
                case FORGE_AUTHOR: {
                    return RefControl.this.canForgeAuthor();
                }
                case FORGE_COMMITTER: {
                    return RefControl.this.canForgeCommitter();
                }
                case FORGE_SERVER: {
                    return RefControl.this.canForgeGerritServerIdentity();
                }
                case MERGE: {
                    return RefControl.this.canUploadMerges();
                }
                case CREATE_CHANGE: {
                    return RefControl.this.canUpload();
                }
                case UPDATE_BY_SUBMIT: {
                    return RefControl.this.projectControl.controlForRef("refs/for/" + RefControl.this.getRefName()).canSubmit(true);
                }
                case SKIP_VALIDATION: {
                    return RefControl.this.canForgeAuthor() && RefControl.this.canForgeCommitter() && RefControl.this.canForgeGerritServerIdentity() && RefControl.this.canUploadMerges() && !RefControl.this.projectControl.getProjectState().isUseSignedOffBy();
                }
            }
            throw new PermissionBackendException((Object)((Object)perm) + " unsupported");
        }
    }

    private static class AllowedRange {
        private int allowMin;
        private int allowMax;
        private int blockMin = Integer.MIN_VALUE;
        private int blockMax = Integer.MAX_VALUE;

        private AllowedRange() {
        }

        void update(PermissionRule rule) {
            if (rule.isBlock()) {
                this.blockMin = Math.max(this.blockMin, rule.getMin());
                this.blockMax = Math.min(this.blockMax, rule.getMax());
            } else {
                this.allowMin = Math.min(this.allowMin, rule.getMin());
                this.allowMax = Math.max(this.allowMax, rule.getMax());
            }
        }

        int getAllowMin() {
            return this.allowMin;
        }

        int getAllowMax() {
            return this.allowMax;
        }

        int getBlockMin() {
            return Math.min(this.blockMin, this.allowMin - 1);
        }

        int getBlockMax() {
            return Math.max(this.blockMax, this.allowMax + 1);
        }
    }
}

