/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.EqualsPathPredicate;
import com.google.gwtorm.server.OrmException;

public class EqualsFilePredicate
extends ChangeIndexPredicate {
    public static Predicate<ChangeData> create(ChangeQueryBuilder.Arguments args, String value) {
        EqualsPathPredicate eqPath = new EqualsPathPredicate("file", value);
        if (!args.getSchema().hasField(ChangeField.FILE_PART)) {
            return eqPath;
        }
        return Predicate.or(eqPath, new EqualsFilePredicate(value));
    }

    private EqualsFilePredicate(String value) {
        super(ChangeField.FILE_PART, "file", value);
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        return ChangeField.getFileParts(object).contains(this.value);
    }

    @Override
    public int getCost() {
        return 1;
    }
}

