/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.collect.Iterables;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.index.change.ChangeIndex;
import com.google.gerrit.server.index.change.IndexedChangeQuery;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gerrit.server.query.change.LegacyChangeIdPredicate;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;

public class FuzzyTopicPredicate
extends ChangeIndexPredicate {
    protected final ChangeIndex index;

    public FuzzyTopicPredicate(String topic, ChangeIndex index) {
        super(ChangeField.FUZZY_TOPIC, topic);
        this.index = index;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        Change change = cd.change();
        if (change == null) {
            return false;
        }
        String t = change.getTopic();
        if (t == null) {
            return false;
        }
        try {
            LegacyChangeIdPredicate thisId = new LegacyChangeIdPredicate(cd.getId());
            ResultSet results = this.index.getSource(FuzzyTopicPredicate.and(thisId, this), IndexedChangeQuery.oneResult()).read();
            return !Iterables.isEmpty(results);
        }
        catch (QueryParseException e) {
            throw new OrmException(e);
        }
    }

    @Override
    public int getCost() {
        return 1;
    }
}

