/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;

public class HasStarsPredicate
extends ChangeIndexPredicate {
    protected final Account.Id accountId;

    public HasStarsPredicate(Account.Id accountId) {
        super(ChangeField.STARBY, accountId.toString());
        this.accountId = accountId;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        return cd.stars().containsKey(this.accountId);
    }

    @Override
    public int getCost() {
        return 1;
    }

    @Override
    public String toString() {
        return "starby:" + this.accountId;
    }
}

