/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeOperatorPredicate;
import com.google.gwtorm.server.OrmException;

public class OwnerinPredicate
extends ChangeOperatorPredicate {
    protected final IdentifiedUser.GenericFactory userFactory;
    protected final AccountGroup.UUID uuid;

    public OwnerinPredicate(IdentifiedUser.GenericFactory userFactory, AccountGroup.UUID uuid) {
        super("ownerin", uuid.toString());
        this.userFactory = userFactory;
        this.uuid = uuid;
    }

    protected AccountGroup.UUID getAccountGroupUUID() {
        return this.uuid;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change change = object.change();
        if (change == null) {
            return false;
        }
        IdentifiedUser owner = this.userFactory.create(change.getOwner());
        return owner.getEffectiveGroups().contains(this.uuid);
    }

    @Override
    public int getCost() {
        return 2;
    }
}

