/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.index.query.QueryRequiresAuthException;
import com.google.gerrit.index.query.QueryResult;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.ChangeQueryProcessor;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.kohsuke.args4j.Option;

public class QueryChanges
implements RestReadView<TopLevelResource> {
    private final ChangeJson.Factory json;
    private final ChangeQueryBuilder qb;
    private final ChangeQueryProcessor imp;
    private EnumSet<ListChangesOption> options;
    @Option(name="--query", aliases={"-q"}, metaVar="QUERY", usage="Query string")
    private List<String> queries;

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="Maximum number of results to return")
    public void setLimit(int limit) {
        this.imp.setUserProvidedLimit(limit);
    }

    @Option(name="-o", usage="Output options per change")
    public void addOption(ListChangesOption o) {
        this.options.add(o);
    }

    @Option(name="-O", usage="Output option flags, in hex")
    void setOptionFlagsHex(String hex) {
        this.options.addAll(ListChangesOption.fromBits(Integer.parseInt(hex, 16)));
    }

    @Option(name="--start", aliases={"-S"}, metaVar="CNT", usage="Number of changes to skip")
    public void setStart(int start) {
        this.imp.setStart(start);
    }

    @Inject
    QueryChanges(ChangeJson.Factory json, ChangeQueryBuilder qb, ChangeQueryProcessor qp) {
        this.json = json;
        this.qb = qb;
        this.imp = qp;
        this.options = EnumSet.noneOf(ListChangesOption.class);
    }

    public void addQuery(String query) {
        if (this.queries == null) {
            this.queries = new ArrayList<String>();
        }
        this.queries.add(query);
    }

    public String getQuery(int i) {
        return this.queries.get(i);
    }

    public List<?> apply(TopLevelResource rsrc) throws BadRequestException, AuthException, OrmException {
        List<List<ChangeInfo>> out;
        try {
            out = this.query();
        }
        catch (QueryRequiresAuthException e) {
            throw new AuthException("Must be signed-in to use this operator");
        }
        catch (QueryParseException e) {
            throw new BadRequestException(e.getMessage(), e);
        }
        return out.size() == 1 ? out.get(0) : out;
    }

    private List<List<ChangeInfo>> query() throws OrmException, QueryParseException {
        if (this.imp.isDisabled()) {
            throw new QueryParseException("query disabled");
        }
        if (this.queries == null || this.queries.isEmpty()) {
            this.queries = Collections.singletonList("status:open");
        } else if (this.queries.size() > 10) {
            throw new QueryParseException("limit of 10 queries");
        }
        int cnt = this.queries.size();
        List<QueryResult<ChangeData>> results = this.imp.query(this.qb.parse(this.queries));
        ChangeJson cjson = this.json.create(this.options);
        cjson.setPluginDefinedAttributesFactory(this.imp);
        List<List<ChangeInfo>> res = cjson.lazyLoad(QueryChanges.containsAnyOf(this.options, ChangeJson.REQUIRE_LAZY_LOAD)).formatQueryResults(results);
        for (int n = 0; n < cnt; ++n) {
            List<ChangeInfo> info = res.get(n);
            if (!results.get(n).more() || info.isEmpty()) continue;
            Iterables.getLast(info)._moreChanges = true;
        }
        return res;
    }

    private static boolean containsAnyOf(EnumSet<ListChangesOption> set, ImmutableSet<ListChangesOption> toFind) {
        return !Sets.intersection(toFind, set).isEmpty();
    }
}

