/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.VersionedMetaData;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;

public class ProjectConfigSchemaUpdate
extends VersionedMetaData {
    private final MetaDataUpdate update;
    private Config config;
    private boolean updated;

    public static ProjectConfigSchemaUpdate read(MetaDataUpdate update) throws IOException, ConfigInvalidException {
        ProjectConfigSchemaUpdate r = new ProjectConfigSchemaUpdate(update);
        r.load(update);
        return r;
    }

    private ProjectConfigSchemaUpdate(MetaDataUpdate update) {
        this.update = update;
    }

    @Override
    protected String getRefName() {
        return "refs/meta/config";
    }

    @Override
    protected void onLoad() throws IOException, ConfigInvalidException {
        this.config = this.readConfig("project.config");
    }

    public void removeForceFromPermission(String name) {
        for (String subsection : this.config.getSubsections("access")) {
            Set<String> names = this.config.getNames("access", subsection);
            if (!names.contains(name)) continue;
            List<String> values = Arrays.stream(this.config.getStringList("access", subsection, name)).map(r -> {
                PermissionRule rule = PermissionRule.fromString(r, false);
                if (rule.getForce().booleanValue()) {
                    rule.setForce(false);
                    this.updated = true;
                }
                return rule.asString(false);
            }).collect(Collectors.toList());
            this.config.setStringList("access", subsection, name, values);
        }
    }

    @Override
    protected boolean onSave(CommitBuilder commit) throws IOException, ConfigInvalidException {
        this.saveConfig("project.config", this.config);
        return true;
    }

    public void save(PersonIdent personIdent, String commitMessage) throws OrmException {
        if (!this.updated) {
            return;
        }
        this.update.getCommitBuilder().setAuthor(personIdent);
        this.update.getCommitBuilder().setCommitter(personIdent);
        this.update.setMessage(commitMessage);
        try {
            this.commit(this.update);
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    public boolean isUpdated() {
        return this.updated;
    }
}

