/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.reviewdb.client.CurrentSchemaVersion;
import com.google.gerrit.reviewdb.client.SystemConfig;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.schema.AllUsersCreator;
import com.google.gerrit.server.schema.ReviewDbFactory;
import com.google.gerrit.server.schema.SchemaCreator;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Stage;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.sql.SQLException;
import java.util.Collections;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;

public class SchemaUpdater {
    private final SchemaFactory<ReviewDb> schema;
    private final SitePaths site;
    private final SchemaCreator creator;
    private final Provider<SchemaVersion> updater;

    @Inject
    SchemaUpdater(@ReviewDbFactory SchemaFactory<ReviewDb> schema, SitePaths site, SchemaCreator creator, Injector parent) {
        this.schema = schema;
        this.site = site;
        this.creator = creator;
        this.updater = SchemaUpdater.buildInjector(parent).getProvider(SchemaVersion.class);
    }

    private static Injector buildInjector(final Injector parent) {
        return Guice.createInjector(Stage.DEVELOPMENT, new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(SchemaVersion.class).to(SchemaVersion.C);
                for (Key k : new Key[]{Key.get(PersonIdent.class, GerritPersonIdent.class), Key.get(String.class, AnonymousCowardName.class), Key.get(Config.class, GerritServerConfig.class)}) {
                    this.rebind(parent, k);
                }
                for (Class c : new Class[]{AllProjectsName.class, AllUsersCreator.class, AllUsersName.class, GitRepositoryManager.class, SitePaths.class, SystemGroupBackend.class}) {
                    this.rebind(parent, Key.get(c));
                }
            }

            private <T> void rebind(Injector parent2, Key<T> c) {
                this.bind(c).toProvider(parent2.getProvider(c));
            }
        });
    }

    public void update(UpdateUI ui) throws OrmException {
        SchemaVersion u;
        CurrentSchemaVersion version;
        ReviewDb db;
        block17: {
            db = ReviewDbUtil.unwrapDb(this.schema.open());
            try {
                version = this.getSchemaVersion(db);
                u = this.updater.get();
                if (version != null) break block17;
                try {
                    this.creator.create(db);
                }
                catch (IOException | ConfigInvalidException e) {
                    throw new OrmException("Cannot initialize schema", e);
                }
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        if (version != null) {
            try {
                u.check(ui, version, this.schema);
            }
            catch (SQLException e) {
                throw new OrmException("Cannot upgrade schema", e);
            }
            db = ReviewDbUtil.unwrapDb(this.schema.open());
            try {
                this.updateSystemConfig(db);
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
    }

    @VisibleForTesting
    public SchemaVersion getLatestSchemaVersion() {
        return this.updater.get();
    }

    private CurrentSchemaVersion getSchemaVersion(ReviewDb db) {
        try {
            return db.schemaVersion().get(new CurrentSchemaVersion.Key());
        }
        catch (OrmException e) {
            return null;
        }
    }

    private void updateSystemConfig(ReviewDb db) throws OrmException {
        SystemConfig sc = db.systemConfig().get(new SystemConfig.Key());
        if (sc == null) {
            throw new OrmException("No record in system_config table");
        }
        try {
            sc.sitePath = this.site.site_path.toRealPath(new LinkOption[0]).normalize().toString();
        }
        catch (IOException e) {
            sc.sitePath = this.site.site_path.toAbsolutePath().normalize().toString();
        }
        db.systemConfig().update(Collections.singleton(sc));
    }
}

