/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.schema.AutoValue_Schema_139_ProjectWatch;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_138;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

public class Schema_139
extends SchemaVersion {
    private static final String MSG = "Migrate project watches to git";
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private final PersonIdent serverUser;

    @Inject
    Schema_139(Provider<Schema_138> prior, GitRepositoryManager repoManager, AllUsersName allUsersName, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        Multimap imports = MultimapBuilder.hashKeys().arrayListValues().build();
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();
             ResultSet rs = stmt.executeQuery("SELECT account_id, project_name, filter, notify_abandoned_changes, notify_all_comments, notify_new_changes, notify_new_patch_sets, notify_submitted_changes FROM account_project_watches");){
            while (rs.next()) {
                Account.Id accountId = new Account.Id(rs.getInt(1));
                ProjectWatch.Builder b = ProjectWatch.builder().project(new Project.NameKey(rs.getString(2))).filter(rs.getString(3)).notifyAbandonedChanges(Schema_139.toBoolean(rs.getString(4))).notifyAllComments(Schema_139.toBoolean(rs.getString(5))).notifyNewChanges(Schema_139.toBoolean(rs.getString(6))).notifyNewPatchSets(Schema_139.toBoolean(rs.getString(7))).notifySubmittedChanges(Schema_139.toBoolean(rs.getString(8)));
                imports.put(accountId, b.build());
            }
        }
        if (imports.isEmpty()) {
            return;
        }
        try (Repository git = this.repoManager.openRepository(this.allUsersName);
             RevWalk rw = new RevWalk(git);){
            BatchRefUpdate bru = git.getRefDatabase().newBatchUpdate();
            bru.setRefLogIdent(this.serverUser);
            bru.setRefLogMessage(MSG, false);
            for (Map.Entry e : imports.asMap().entrySet()) {
                HashMap<WatchConfig.ProjectWatchKey, Set<WatchConfig.NotifyType>> projectWatches = new HashMap<WatchConfig.ProjectWatchKey, Set<WatchConfig.NotifyType>>();
                for (ProjectWatch projectWatch : e.getValue()) {
                    WatchConfig.ProjectWatchKey key = WatchConfig.ProjectWatchKey.create(projectWatch.project(), projectWatch.filter());
                    if (projectWatches.containsKey(key)) {
                        throw new OrmDuplicateKeyException("Duplicate key for watched project: " + key.toString());
                    }
                    EnumSet<WatchConfig.NotifyType> notifyValues = EnumSet.noneOf(WatchConfig.NotifyType.class);
                    if (projectWatch.notifyAbandonedChanges()) {
                        notifyValues.add(WatchConfig.NotifyType.ABANDONED_CHANGES);
                    }
                    if (projectWatch.notifyAllComments()) {
                        notifyValues.add(WatchConfig.NotifyType.ALL_COMMENTS);
                    }
                    if (projectWatch.notifyNewChanges()) {
                        notifyValues.add(WatchConfig.NotifyType.NEW_CHANGES);
                    }
                    if (projectWatch.notifyNewPatchSets()) {
                        notifyValues.add(WatchConfig.NotifyType.NEW_PATCHSETS);
                    }
                    if (projectWatch.notifySubmittedChanges()) {
                        notifyValues.add(WatchConfig.NotifyType.SUBMITTED_CHANGES);
                    }
                    projectWatches.put(key, notifyValues);
                }
                try (MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allUsersName, git, bru);){
                    md.getCommitBuilder().setAuthor(this.serverUser);
                    md.getCommitBuilder().setCommitter(this.serverUser);
                    md.setMessage(MSG);
                    WatchConfig watchConfig = new WatchConfig((Account.Id)e.getKey());
                    watchConfig.load(md);
                    watchConfig.setProjectWatches(projectWatches);
                    watchConfig.commit(md);
                }
            }
            bru.execute(rw, NullProgressMonitor.INSTANCE);
        }
        catch (IOException | ConfigInvalidException ex) {
            throw new OrmException(ex);
        }
    }

    private static boolean toBoolean(String v) {
        Preconditions.checkState(!Strings.isNullOrEmpty(v));
        return v.equals("Y");
    }

    @AutoValue
    static abstract class ProjectWatch {
        ProjectWatch() {
        }

        abstract Project.NameKey project();

        @Nullable
        abstract String filter();

        abstract boolean notifyAbandonedChanges();

        abstract boolean notifyAllComments();

        abstract boolean notifyNewChanges();

        abstract boolean notifyNewPatchSets();

        abstract boolean notifySubmittedChanges();

        static Builder builder() {
            return new AutoValue_Schema_139_ProjectWatch.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder project(Project.NameKey var1);

            abstract Builder filter(@Nullable String var1);

            abstract Builder notifyAbandonedChanges(boolean var1);

            abstract Builder notifyAllComments(boolean var1);

            abstract Builder notifyNewChanges(boolean var1);

            abstract Builder notifyNewPatchSets(boolean var1);

            abstract Builder notifySubmittedChanges(boolean var1);

            abstract ProjectWatch build();
        }
    }
}

