/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;
import org.kohsuke.args4j.Argument;

@RequiresCapability(value="administrateServer")
@CommandMetaData(name="set-level", description="Change the level of loggers", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
public class SetLoggingLevelCommand
extends SshCommand {
    private static final String LOG_CONFIGURATION = "log4j.properties";
    private static final String JAVA_OPTIONS_LOG_CONFIG = "log4j.configuration";
    @Argument(index=0, required=true, metaVar="LEVEL", usage="logging level to set to")
    private LevelOption level;
    @Argument(index=1, required=false, metaVar="NAME", usage="used to match loggers")
    private String name;

    @Override
    protected void run() throws MalformedURLException {
        if (this.level == LevelOption.RESET) {
            SetLoggingLevelCommand.reset();
        } else {
            Enumeration logger = LogManager.getCurrentLoggers();
            while (logger.hasMoreElements()) {
                Logger log = (Logger)logger.nextElement();
                if (this.name != null && !log.getName().contains(this.name)) continue;
                log.setLevel(Level.toLevel(this.level.name()));
            }
        }
    }

    private static void reset() throws MalformedURLException {
        Enumeration logger = LogManager.getCurrentLoggers();
        while (logger.hasMoreElements()) {
            ((Logger)logger.nextElement()).setLevel(null);
        }
        String path = System.getProperty(JAVA_OPTIONS_LOG_CONFIG);
        if (Strings.isNullOrEmpty(path)) {
            PropertyConfigurator.configure(Loader.getResource(LOG_CONFIGURATION));
        } else {
            PropertyConfigurator.configure(new URL(path));
        }
    }

    private static enum LevelOption {
        ALL,
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL,
        OFF,
        RESET;

    }
}

