/*
 * Decompiled with CFR 0.152.
 */
package com.google.gitiles.blame.cache;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gitiles.blame.cache.BlameCache;
import com.google.gitiles.blame.cache.Region;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.jgit.blame.BlameGenerator;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.QuotedString;

public class BlameCacheImpl
implements BlameCache {
    private final Cache<Key, List<Region>> cache;

    public static CacheBuilder<Key, List<Region>> defaultBuilder() {
        return BlameCacheImpl.weigher(CacheBuilder.newBuilder()).maximumWeight(10240L);
    }

    public static CacheBuilder<Key, List<Region>> weigher(CacheBuilder<? super Key, ? super List<Region>> builder) {
        return builder.weigher((k, v) -> v.size());
    }

    public BlameCacheImpl() {
        this(BlameCacheImpl.defaultBuilder());
    }

    public Cache<Key, List<Region>> getCache() {
        return this.cache;
    }

    public Callable<List<Region>> newLoader(Key key, Repository repo) {
        return () -> BlameCacheImpl.loadBlame(key, repo);
    }

    public BlameCacheImpl(CacheBuilder<? super Key, ? super List<Region>> builder) {
        this.cache = builder.build();
    }

    @Override
    public List<Region> get(Repository repo, ObjectId commitId, String path) throws IOException {
        try {
            Key key = new Key(commitId, path);
            return this.cache.get(key, this.newLoader(key, repo));
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public ObjectId findLastCommit(Repository repo, ObjectId commitId, String path) throws IOException {
        try (RevWalk rw = new RevWalk(repo);){
            rw.markStart(rw.parseCommit(commitId));
            rw.setRewriteParents(false);
            rw.setTreeFilter(AndTreeFilter.create(PathFilterGroup.createFromStrings(path), TreeFilter.ANY_DIFF));
            RevCommit revCommit = rw.next();
            return revCommit;
        }
    }

    public static List<Region> loadBlame(Key key, Repository repo) throws IOException {
        try (BlameGenerator gen = new BlameGenerator(repo, key.path);){
            gen.push(null, key.commitId);
            List<Region> list = BlameCacheImpl.loadRegions(gen);
            return list;
        }
    }

    private static List<Region> loadRegions(BlameGenerator gen) throws IOException {
        HashMap<ObjectId, PooledCommit> commits = Maps.newHashMap();
        Interner<String> strings = Interners.newStrongInterner();
        int lineCount = gen.getResultContents().size();
        ArrayList<Region> regions = Lists.newArrayList();
        while (gen.next()) {
            String path = gen.getSourcePath();
            PersonIdent author = gen.getSourceAuthor();
            ObjectId commit = gen.getSourceCommit();
            Preconditions.checkState(path != null && author != null && commit != null);
            PooledCommit pc = (PooledCommit)commits.get(commit);
            if (pc == null) {
                pc = new PooledCommit(commit.copy(), new PersonIdent(strings.intern(author.getName()), strings.intern(author.getEmailAddress()), author.getWhen(), author.getTimeZone()));
                commits.put(pc.commit, pc);
            }
            path = strings.intern(path);
            commit = pc.commit;
            author = pc.author;
            regions.add(new Region(path, commit, author, gen.getResultStart(), gen.getResultEnd()));
        }
        Collections.sort(regions);
        ArrayList<Region> result = Lists.newArrayListWithExpectedSize(regions.size());
        Region last = null;
        for (Region r : regions) {
            if (last != null) {
                Preconditions.checkState(last.getEnd() <= r.getStart());
                if (last.getEnd() < r.getStart()) {
                    result.add(new Region(null, null, null, last.getEnd(), r.getStart()));
                }
            }
            result.add(r);
            last = r;
        }
        if (last != null && last.getEnd() != lineCount) {
            result.add(new Region(null, null, null, last.getEnd(), lineCount));
        }
        return ImmutableList.copyOf(result);
    }

    private static class PooledCommit {
        final ObjectId commit;
        final PersonIdent author;

        private PooledCommit(ObjectId commit, PersonIdent author) {
            this.commit = commit;
            this.author = author;
        }
    }

    public static class Key {
        private final ObjectId commitId;
        private final String path;

        public Key(ObjectId commitId, String path) {
            this.commitId = commitId;
            this.path = path;
        }

        public ObjectId getCommitId() {
            return this.commitId;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                return Objects.equals(this.commitId, k.commitId) && Objects.equals(this.path, k.path);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.commitId, this.path);
        }

        public String toString() {
            return this.commitId.name() + ":" + QuotedString.GIT_PATH.quote(this.path);
        }
    }
}

