/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.RenderResult;
import java.io.IOException;
import javax.annotation.Nullable;

public abstract class SoyAbstractCachingValueProvider
implements SoyValueProvider {
    private volatile SoyValue resolvedValue = null;
    @Nullable
    private ValueAssertion valueAssertion;

    @Override
    public final SoyValue resolve() {
        SoyValue localResolvedValue = this.resolvedValue;
        if (localResolvedValue == null) {
            localResolvedValue = this.compute();
            ValueAssertion curr = this.valueAssertion;
            while (curr != null) {
                curr.check(localResolvedValue);
                curr = curr.next;
            }
            this.resolvedValue = localResolvedValue;
            this.valueAssertion = null;
        }
        return localResolvedValue;
    }

    @Override
    public RenderResult renderAndResolve(AdvisingAppendable appendable, boolean isLast) throws IOException {
        RenderResult result = this.status();
        if (result.type() == RenderResult.Type.DONE) {
            this.resolve().render(appendable);
        }
        return result;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("SoyAbstractCachingValueProvider is unsuitable for use as a hash key.");
    }

    public final boolean isComputed() {
        return this.resolvedValue != null;
    }

    public void addValueAssertion(ValueAssertion assertion) {
        Preconditions.checkState(this.resolvedValue == null, "ValueAssertions should only be registered if the value is not yet computed.");
        assertion.next = this.valueAssertion;
        this.valueAssertion = assertion;
    }

    protected abstract SoyValue compute();

    public static abstract class ValueAssertion {
        private ValueAssertion next;

        public abstract void check(SoyValue var1);
    }
}

