/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internalutils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.protobuf.Descriptors;
import com.google.template.soy.data.SanitizedContent;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Set;

public class NodeContentKinds {
    private static final ImmutableBiMap<String, SanitizedContent.ContentKind> KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put("attributes", (Object)SanitizedContent.ContentKind.ATTRIBUTES)).put("css", (Object)SanitizedContent.ContentKind.CSS)).put("html", (Object)SanitizedContent.ContentKind.HTML)).put("js", (Object)SanitizedContent.ContentKind.JS)).put("text", (Object)SanitizedContent.ContentKind.TEXT)).put("uri", (Object)SanitizedContent.ContentKind.URI)).put("trusted_resource_uri", (Object)SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI)).build();
    private static final ImmutableMap<SanitizedContent.ContentKind, String> KIND_TO_JS_CTOR_NAME = ImmutableMap.builder().put(SanitizedContent.ContentKind.HTML, "goog.soy.data.SanitizedHtml").put(SanitizedContent.ContentKind.ATTRIBUTES, "goog.soy.data.SanitizedHtmlAttribute").put(SanitizedContent.ContentKind.JS, "goog.soy.data.SanitizedJs").put(SanitizedContent.ContentKind.URI, "goog.soy.data.SanitizedUri").put(SanitizedContent.ContentKind.CSS, "goog.soy.data.SanitizedCss").put(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI, "goog.soy.data.SanitizedTrustedResourceUri").put(SanitizedContent.ContentKind.TEXT, "goog.soy.data.UnsanitizedText").build();
    private static final ImmutableMap<SanitizedContent.ContentKind, String> IDOM_KIND_TO_JS_CTOR_NAME = ImmutableMap.builder().put(SanitizedContent.ContentKind.HTML, "Function").put(SanitizedContent.ContentKind.ATTRIBUTES, "Function").put(SanitizedContent.ContentKind.JS, "goog.soy.data.SanitizedJs").put(SanitizedContent.ContentKind.URI, "goog.soy.data.SanitizedUri").put(SanitizedContent.ContentKind.CSS, "goog.soy.data.SanitizedCss").put(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI, "goog.soy.data.SanitizedTrustedResourceUri").put(SanitizedContent.ContentKind.TEXT, "goog.soy.data.UnsanitizedText").build();
    private static final ImmutableMap<SanitizedContent.ContentKind, String> KIND_TO_JS_ORDAINER_NAME = ImmutableMap.builder().put(SanitizedContent.ContentKind.HTML, "soydata.VERY_UNSAFE.ordainSanitizedHtml").put(SanitizedContent.ContentKind.ATTRIBUTES, "soydata.VERY_UNSAFE.ordainSanitizedHtmlAttribute").put(SanitizedContent.ContentKind.JS, "soydata.VERY_UNSAFE.ordainSanitizedJs").put(SanitizedContent.ContentKind.URI, "soydata.VERY_UNSAFE.ordainSanitizedUri").put(SanitizedContent.ContentKind.CSS, "soydata.VERY_UNSAFE.ordainSanitizedCss").put(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI, "soydata.VERY_UNSAFE.ordainSanitizedTrustedResourceUri").put(SanitizedContent.ContentKind.TEXT, "soydata.markUnsanitizedText").build();
    private static final ImmutableMap<SanitizedContent.ContentKind, String> KIND_TO_JS_ORDAINER_NAME_FOR_INTERNAL_BLOCKS = ImmutableMap.builder().put(SanitizedContent.ContentKind.HTML, "soydata.VERY_UNSAFE.$$ordainSanitizedHtmlForInternalBlocks").put(SanitizedContent.ContentKind.ATTRIBUTES, "soydata.VERY_UNSAFE.$$ordainSanitizedAttributesForInternalBlocks").put(SanitizedContent.ContentKind.JS, "soydata.VERY_UNSAFE.$$ordainSanitizedJsForInternalBlocks").put(SanitizedContent.ContentKind.URI, "soydata.VERY_UNSAFE.$$ordainSanitizedUriForInternalBlocks").put(SanitizedContent.ContentKind.CSS, "soydata.VERY_UNSAFE.$$ordainSanitizedCssForInternalBlocks").put(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI, "soydata.VERY_UNSAFE.$$ordainSanitizedTrustedResourceUriForInternalBlocks").put(SanitizedContent.ContentKind.TEXT, "soydata.$$markUnsanitizedTextForInternalBlocks").build();
    private static final ImmutableMap<String, String> PROTO_TO_JS_UNPACK_FN = ImmutableMap.builder().put(SafeHtmlProto.getDescriptor().getFullName(), "soydata.unpackProtoToSanitizedHtml").put(SafeScriptProto.getDescriptor().getFullName(), "soydata.unpackProtoToSanitizedJs").put(SafeUrlProto.getDescriptor().getFullName(), "soydata.unpackProtoToSanitizedUri").put(SafeStyleProto.getDescriptor().getFullName(), "soydata.unpackProtoToSanitizedCss").put(SafeStyleSheetProto.getDescriptor().getFullName(), "soydata.unpackProtoToSanitizedCss").put(TrustedResourceUrlProto.getDescriptor().getFullName(), "soydata.unpackProtoToSanitizedTrustedResourceUri").build();
    private static final ImmutableMap<String, String> JS_TO_PROTO_PACK_FN = ImmutableMap.builder().put(SafeHtmlProto.getDescriptor().getFullName(), "soydata.packSanitizedHtmlToProtoSoyRuntimeOnly").put(SafeScriptProto.getDescriptor().getFullName(), "soydata.packSanitizedJsToProtoSoyRuntimeOnly").put(SafeUrlProto.getDescriptor().getFullName(), "soydata.packSanitizedUriToProtoSoyRuntimeOnly").put(SafeStyleProto.getDescriptor().getFullName(), "soydata.packSanitizedCssToSafeStyleProtoSoyRuntimeOnly").put(SafeStyleSheetProto.getDescriptor().getFullName(), "soydata.packSanitizedCssToSafeStyleSheetProtoSoyRuntimeOnly").put(TrustedResourceUrlProto.getDescriptor().getFullName(), "soydata.packSanitizedTrustedResourceUriToProtoSoyRuntimeOnly").build();
    private static final ImmutableMap<SanitizedContent.ContentKind, String> KIND_TO_PY_SANITIZED_NAME = ImmutableMap.builder().put(SanitizedContent.ContentKind.HTML, "sanitize.SanitizedHtml").put(SanitizedContent.ContentKind.ATTRIBUTES, "sanitize.SanitizedHtmlAttribute").put(SanitizedContent.ContentKind.JS, "sanitize.SanitizedJs").put(SanitizedContent.ContentKind.URI, "sanitize.SanitizedUri").put(SanitizedContent.ContentKind.CSS, "sanitize.SanitizedCss").put(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI, "sanitize.SanitizedTrustedResourceUri").put(SanitizedContent.ContentKind.TEXT, "sanitize.UnsanitizedText").build();

    public static SanitizedContent.ContentKind forAttributeValue(String attributeValue) {
        return (SanitizedContent.ContentKind)((Object)KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP.get(attributeValue));
    }

    public static String toAttributeValue(SanitizedContent.ContentKind kind) {
        return (String)((ImmutableMap)((Object)KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP.inverse())).get((Object)kind);
    }

    public static Set<String> getAttributeValues() {
        return KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP.keySet();
    }

    public static String toJsSanitizedContentCtorName(SanitizedContent.ContentKind contentKind) {
        return Preconditions.checkNotNull(KIND_TO_JS_CTOR_NAME.get((Object)contentKind));
    }

    public static String toIDOMSanitizedContentCtorName(SanitizedContent.ContentKind contentKind) {
        return Preconditions.checkNotNull(IDOM_KIND_TO_JS_CTOR_NAME.get((Object)contentKind));
    }

    public static String toJsSanitizedContentOrdainer(SanitizedContent.ContentKind contentKind) {
        return Preconditions.checkNotNull(KIND_TO_JS_ORDAINER_NAME.get((Object)contentKind));
    }

    public static String toJsSanitizedContentOrdainerForInternalBlocks(SanitizedContent.ContentKind contentKind) {
        return Preconditions.checkNotNull(KIND_TO_JS_ORDAINER_NAME_FOR_INTERNAL_BLOCKS.get((Object)contentKind));
    }

    public static String getJsImportForOrdainersFunctions(SanitizedContent.ContentKind contentKind) {
        if (contentKind == SanitizedContent.ContentKind.TEXT) {
            return "soydata";
        }
        return "soydata.VERY_UNSAFE";
    }

    public static String toJsPackFunction(Descriptors.Descriptor protoDescriptor) {
        return Preconditions.checkNotNull(JS_TO_PROTO_PACK_FN.get(protoDescriptor.getFullName()));
    }

    public static String toJsUnpackFunction(Descriptors.Descriptor protoDescriptor) {
        return Preconditions.checkNotNull(PROTO_TO_JS_UNPACK_FN.get(protoDescriptor.getFullName()));
    }

    public static String toPySanitizedContentOrdainer(SanitizedContent.ContentKind contentKind) {
        return Preconditions.checkNotNull(KIND_TO_PY_SANITIZED_NAME.get((Object)contentKind));
    }

    private NodeContentKinds() {
    }

    static {
        if (!((AbstractCollection)((Object)KIND_TO_JS_CTOR_NAME.keySet())).containsAll(EnumSet.allOf(SanitizedContent.ContentKind.class))) {
            throw new AssertionError((Object)"Not all ContentKind enums have a JS constructor");
        }
        if (!((AbstractCollection)((Object)IDOM_KIND_TO_JS_CTOR_NAME.keySet())).containsAll(EnumSet.allOf(SanitizedContent.ContentKind.class))) {
            throw new AssertionError((Object)"Not all ContentKind enums have a Incremental DOM JS constructor");
        }
        ImmutableCollection soyContentKinds = KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP.values();
        if (!((AbstractCollection)((Object)KIND_TO_JS_ORDAINER_NAME.keySet())).containsAll(soyContentKinds)) {
            throw new AssertionError((Object)"Not all Soy-accessible ContentKind enums have a JS ordainer");
        }
        if (!((AbstractCollection)((Object)KIND_TO_JS_ORDAINER_NAME_FOR_INTERNAL_BLOCKS.keySet())).containsAll(soyContentKinds)) {
            throw new AssertionError((Object)"Not all Soy-accessible ContentKind enums have a JS ordainer");
        }
        if (!((AbstractCollection)((Object)KIND_TO_PY_SANITIZED_NAME.keySet())).containsAll(soyContentKinds)) {
            throw new AssertionError((Object)"Not all Soy-accessible ContentKind enums have a Python sanitizer");
        }
    }
}

