/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.BaseUtils;

public final class Names {
    public static final String CLASS_PREFIX = "com.google.template.soy.jbcsrc.gen.";
    public static final String INTERNAL_CLASS_PREFIX = "com.google.template.soy.jbcsrc.gen.".replace('.', '/');

    private Names() {
    }

    public static String javaClassNameFromSoyTemplateName(String soyTemplate) {
        Preconditions.checkArgument(BaseUtils.isDottedIdentifier(soyTemplate), "%s is not a valid template name.", (Object)soyTemplate);
        return CLASS_PREFIX + soyTemplate;
    }

    public static String javaFileName(String soyNamespace, String fileName) {
        Preconditions.checkArgument(BaseUtils.isDottedIdentifier(soyNamespace), "%s is not a valid soy namspace name.", (Object)soyNamespace);
        return (CLASS_PREFIX + soyNamespace).replace('.', '/') + '/' + fileName;
    }

    public static String soyTemplateNameFromJavaClassName(String javaClass) {
        if (!javaClass.startsWith(CLASS_PREFIX)) {
            throw new IllegalArgumentException("java class: " + javaClass + " is not a mangled soy template name");
        }
        return javaClass.substring(CLASS_PREFIX.length());
    }

    public static void rewriteStackTrace(Throwable throwable) {
        StackTraceElement[] stack = throwable.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement curr = stack[i];
            if (!curr.getClassName().startsWith(CLASS_PREFIX)) continue;
            stack[i] = new StackTraceElement(Names.soyTemplateNameFromJavaClassName(curr.getClassName()), curr.getMethodName(), curr.getFileName(), curr.getLineNumber());
        }
        throwable.setStackTrace(stack);
    }
}

