/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.proto.AmbiguousFieldSet;
import com.google.template.soy.types.proto.ExtensionField;
import com.google.template.soy.types.proto.Field;
import com.google.template.soy.types.proto.JavaQualifiedNames;
import com.google.template.soy.types.proto.NormalField;
import com.google.template.soy.types.proto.Protos;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SoyProtoType
implements SoyType {
    private static final Logger logger = Logger.getLogger(SoyProtoType.class.getName());
    private final Descriptors.Descriptor typeDescriptor;
    private final ImmutableMap<String, Field> fields;

    SoyProtoType(SoyTypeRegistry typeRegistry, Descriptors.Descriptor descriptor, Set<Descriptors.FieldDescriptor> extensions) {
        this.typeDescriptor = descriptor;
        ImmutableMap.Builder<String, Field> fields = ImmutableMap.builder();
        for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            if (Protos.shouldJsIgnoreField(fieldDescriptor)) continue;
            NormalField normalField = new NormalField(typeRegistry, fieldDescriptor);
            fields.put(normalField.getName(), normalField);
        }
        Multimap extensionsBySoyName = MultimapBuilder.hashKeys().hashSetValues().build();
        for (Descriptors.FieldDescriptor fieldDescriptor : extensions) {
            ExtensionField field = new ExtensionField(typeRegistry, fieldDescriptor);
            extensionsBySoyName.put(field.getName(), field);
        }
        for (Map.Entry entry : Multimaps.asMap(extensionsBySoyName).entrySet()) {
            String fieldName = (String)entry.getKey();
            Set ambiguousFields = (Set)entry.getValue();
            if (ambiguousFields.size() == 1) {
                fields.put(fieldName, (Field)Iterables.getOnlyElement(ambiguousFields));
                continue;
            }
            AmbiguousFieldSet value = new AmbiguousFieldSet(fieldName, ambiguousFields);
            logger.severe("Proto " + descriptor.getFullName() + " has multiple extensions with the name \"" + fieldName + "\": " + value.getFullFieldNames() + "\nThis field will not be accessible from soy");
            fields.put(fieldName, value);
        }
        this.fields = fields.build();
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.PROTO;
    }

    @Override
    public boolean isAssignableFrom(SoyType fromType) {
        return fromType == this;
    }

    @Override
    public boolean isInstance(SoyValue value) {
        return value instanceof SoyProtoValue && ((SoyProtoValue)value).getProto().getDescriptorForType() == this.typeDescriptor;
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.typeDescriptor;
    }

    public String getDescriptorExpression() {
        Descriptors.Descriptor descriptor = this.typeDescriptor;
        while (descriptor.getContainingType() != null) {
            descriptor = descriptor.getContainingType();
        }
        return JavaQualifiedNames.getQualifiedName(descriptor) + ".getDescriptor()";
    }

    public Descriptors.FieldDescriptor getFieldDescriptor(String fieldName) {
        return this.fields.get(fieldName).getDescriptor();
    }

    @Nullable
    public Field getField(String name) {
        return this.fields.get(name);
    }

    @Nullable
    public SoyType getFieldType(String fieldName) {
        Field field = this.fields.get(fieldName);
        return field != null ? field.getType() : null;
    }

    public ImmutableSet<String> getFieldNames() {
        return this.fields.keySet();
    }

    public String getNameForBackend(SoyBackendKind backend) {
        switch (backend) {
            case JS_SRC: {
                return Protos.calculateQualifiedJsName(this.typeDescriptor);
            }
            case TOFU: 
            case JBC_SRC: {
                return JavaQualifiedNames.getClassName(this.typeDescriptor);
            }
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.typeDescriptor.getFullName();
    }
}

