/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.exceptions.EvaluationException;
import com.googlecode.prolog_cafe.exceptions.IllegalTypeException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.NumberTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.Trail;
import com.googlecode.prolog_cafe.lang.VariableTerm;

public class DoubleTerm
extends NumberTerm {
    protected double val;

    public DoubleTerm(double d) {
        this.val = d;
    }

    public double value() {
        return this.val;
    }

    @Override
    public int type() {
        return 2;
    }

    @Override
    public boolean unify(Term term, Trail trail) {
        if (term instanceof VariableTerm) {
            return ((VariableTerm)term).unify(this, trail);
        }
        if (!(term instanceof DoubleTerm)) {
            return false;
        }
        return this.val == ((DoubleTerm)term).value();
    }

    @Override
    public String name() {
        return "";
    }

    @Override
    public boolean convertible(Class<?> clazz) {
        return DoubleTerm.convertible(Double.class, clazz);
    }

    @Override
    public Object toJava() {
        return this.val;
    }

    public String toString() {
        return Double.toString(this.val);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DoubleTerm)) {
            return false;
        }
        return Double.doubleToLongBits(this.val) == Double.doubleToLongBits(((DoubleTerm)object).val);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.val);
        return (int)(l ^ l >>> 32);
    }

    @Override
    public int compareTo(Term term) {
        if (term instanceof VariableTerm) {
            return 1;
        }
        if (!(term instanceof DoubleTerm)) {
            return -1;
        }
        return Double.compare(this.val, ((DoubleTerm)term).value());
    }

    @Override
    public int intValue() {
        return (int)this.val;
    }

    @Override
    public long longValue() {
        return (long)this.val;
    }

    @Override
    public double doubleValue() {
        return this.val;
    }

    @Override
    public int arithCompareTo(NumberTerm numberTerm) {
        return Double.compare(this.val, numberTerm.doubleValue());
    }

    @Override
    public NumberTerm abs() {
        return new DoubleTerm(Math.abs(this.val));
    }

    @Override
    public NumberTerm acos() {
        return new DoubleTerm(Math.acos(this.val));
    }

    @Override
    public NumberTerm add(NumberTerm numberTerm) {
        return new DoubleTerm(this.val + numberTerm.doubleValue());
    }

    @Override
    public NumberTerm and(NumberTerm numberTerm) {
        throw new IllegalTypeException("integer", this);
    }

    @Override
    public NumberTerm asin() {
        return new DoubleTerm(Math.asin(this.val));
    }

    @Override
    public NumberTerm atan() {
        return new DoubleTerm(Math.atan(this.val));
    }

    @Override
    public NumberTerm ceil() {
        return new IntegerTerm((int)Math.ceil(this.val));
    }

    @Override
    public NumberTerm cos() {
        return new DoubleTerm(Math.cos(this.val));
    }

    @Override
    public NumberTerm divide(NumberTerm numberTerm) {
        if (numberTerm.doubleValue() == 0.0) {
            throw new EvaluationException("zero_divisor");
        }
        return new DoubleTerm(this.val / numberTerm.doubleValue());
    }

    @Override
    public NumberTerm exp() {
        return new DoubleTerm(Math.exp(this.val));
    }

    @Override
    public NumberTerm floatIntPart() {
        return new DoubleTerm(Math.signum(this.val) * Math.floor(Math.abs(this.val)));
    }

    @Override
    public NumberTerm floatFractPart() {
        return new DoubleTerm(this.val - Math.signum(this.val) * Math.floor(Math.abs(this.val)));
    }

    @Override
    public NumberTerm floor() {
        return new IntegerTerm((int)Math.floor(this.val));
    }

    @Override
    public NumberTerm intDivide(NumberTerm numberTerm) {
        throw new IllegalTypeException("integer", this);
    }

    @Override
    public NumberTerm log() {
        if (this.val == 0.0) {
            throw new EvaluationException("undefined");
        }
        return new DoubleTerm(Math.log(this.val));
    }

    @Override
    public NumberTerm max(NumberTerm numberTerm) {
        return new DoubleTerm(Math.max(this.val, numberTerm.doubleValue()));
    }

    @Override
    public NumberTerm min(NumberTerm numberTerm) {
        return new DoubleTerm(Math.min(this.val, numberTerm.doubleValue()));
    }

    @Override
    public NumberTerm mod(NumberTerm numberTerm) {
        throw new IllegalTypeException("integer", this);
    }

    @Override
    public NumberTerm multiply(NumberTerm numberTerm) {
        return new DoubleTerm(this.val * numberTerm.doubleValue());
    }

    @Override
    public NumberTerm negate() {
        return new DoubleTerm(-this.val);
    }

    @Override
    public NumberTerm not() {
        throw new IllegalTypeException("integer", this);
    }

    @Override
    public NumberTerm or(NumberTerm numberTerm) {
        throw new IllegalTypeException("integer", this);
    }

    @Override
    public NumberTerm pow(NumberTerm numberTerm) {
        return new DoubleTerm(Math.pow(this.val, numberTerm.doubleValue()));
    }

    @Override
    public NumberTerm rint() {
        return new DoubleTerm(Math.rint(this.val));
    }

    @Override
    public NumberTerm round() {
        return new IntegerTerm((int)Math.round(this.val));
    }

    @Override
    public NumberTerm shiftLeft(NumberTerm numberTerm) {
        throw new IllegalTypeException("integer", this);
    }

    @Override
    public NumberTerm shiftRight(NumberTerm numberTerm) {
        throw new IllegalTypeException("integer", this);
    }

    @Override
    public NumberTerm signum() {
        return new DoubleTerm(Math.signum(this.val));
    }

    @Override
    public NumberTerm sin() {
        return new DoubleTerm(Math.sin(this.val));
    }

    @Override
    public NumberTerm sqrt() {
        if (this.val < 0.0) {
            throw new EvaluationException("undefined");
        }
        return new DoubleTerm(Math.sqrt(this.val));
    }

    @Override
    public NumberTerm subtract(NumberTerm numberTerm) {
        return new DoubleTerm(this.val - numberTerm.doubleValue());
    }

    @Override
    public NumberTerm tan() {
        return new DoubleTerm(Math.tan(this.val));
    }

    @Override
    public NumberTerm toDegrees() {
        return new DoubleTerm(Math.toDegrees(this.val));
    }

    @Override
    public NumberTerm toFloat() {
        return this;
    }

    @Override
    public NumberTerm toRadians() {
        return new DoubleTerm(Math.toRadians(this.val));
    }

    @Override
    public NumberTerm truncate() {
        if (this.val >= 0.0) {
            return new IntegerTerm((int)Math.floor(this.val));
        }
        return new IntegerTerm((int)(-1.0 * Math.floor(Math.abs(this.val))));
    }

    @Override
    public NumberTerm xor(NumberTerm numberTerm) {
        throw new IllegalTypeException("integer", this);
    }
}

