/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class Nio2Connector
extends Nio2Service
implements IoConnector {
    public Nio2Connector(FactoryManager manager, IoHandler handler, AsynchronousChannelGroup group) {
        super(manager, handler, group);
    }

    @Override
    public IoConnectFuture connect(SocketAddress address) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Connecting to {}", (Object)address);
        }
        DefaultIoConnectFuture future = new DefaultIoConnectFuture((Object)null);
        try {
            AsynchronousChannelGroup group = this.getChannelGroup();
            AsynchronousSocketChannel socket = this.setSocketOptions(this.openAsynchronousSocketChannel(address, group));
            Nio2CompletionHandler<Void, Object> completionHandler = ValidateUtils.checkNotNull(this.createConnectionCompletionHandler(future, socket, this.getFactoryManager(), this.getIoHandler()), "No connection completion handler created for %s", (Object)address);
            socket.connect(address, null, completionHandler);
        }
        catch (Throwable exc) {
            Throwable t = GenericUtils.peelException(exc);
            if (this.log.isDebugEnabled()) {
                this.log.debug("connect({}) failed ({}) to schedule connection: {}", address, t.getClass().getSimpleName(), t.getMessage());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("connect(" + address + ") connection failure details", t);
            }
            future.setException(t);
        }
        return future;
    }

    protected AsynchronousSocketChannel openAsynchronousSocketChannel(SocketAddress address, AsynchronousChannelGroup group) throws IOException {
        return AsynchronousSocketChannel.open(group);
    }

    protected Nio2CompletionHandler<Void, Object> createConnectionCompletionHandler(final IoConnectFuture future, final AsynchronousSocketChannel socket, final FactoryManager manager, final IoHandler handler) {
        return new Nio2CompletionHandler<Void, Object>(){

            @Override
            protected void onCompleted(Void result, Object attachment) {
                try {
                    Nio2Session session = Nio2Connector.this.createSession(manager, handler, socket);
                    handler.sessionCreated(session);
                    Nio2Connector.this.sessions.put(session.getId(), session);
                    future.setSession(session);
                    session.startReading();
                }
                catch (Throwable exc) {
                    Throwable t;
                    block6: {
                        t = GenericUtils.peelException(exc);
                        if (Nio2Connector.this.log.isDebugEnabled()) {
                            Nio2Connector.this.log.debug("onCompleted - failed {} to start session: {}", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
                        }
                        if (Nio2Connector.this.log.isTraceEnabled()) {
                            Nio2Connector.this.log.trace("onCompleted - session creation failure details", t);
                        }
                        try {
                            socket.close();
                        }
                        catch (IOException err) {
                            if (!Nio2Connector.this.log.isDebugEnabled()) break block6;
                            Nio2Connector.this.log.debug("onCompleted - failed {} to close socket: {}", (Object)err.getClass().getSimpleName(), (Object)err.getMessage());
                        }
                    }
                    future.setException(t);
                }
            }

            @Override
            protected void onFailed(Throwable exc, Object attachment) {
                future.setException(exc);
            }
        };
    }

    protected Nio2Session createSession(FactoryManager manager, IoHandler handler, AsynchronousSocketChannel socket) throws Throwable {
        return new Nio2Session(this, manager, handler, socket);
    }

    public static class DefaultIoConnectFuture
    extends DefaultSshFuture<IoConnectFuture>
    implements IoConnectFuture {
        public DefaultIoConnectFuture(Object lock) {
            super(lock);
        }

        @Override
        public IoSession getSession() {
            Object v = this.getValue();
            return v instanceof IoSession ? (IoSession)v : null;
        }

        @Override
        public Throwable getException() {
            Object v = this.getValue();
            return v instanceof Throwable ? (Throwable)v : null;
        }

        @Override
        public boolean isConnected() {
            return this.getValue() instanceof IoSession;
        }

        @Override
        public void setSession(IoSession session) {
            this.setValue(session);
        }

        @Override
        public void setException(Throwable exception) {
            this.setValue(exception);
        }
    }
}

