/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPrivateKeyEntryDecoder;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.EdDSASecurityProviderUtils;

public class OpenSSHEd25519PrivateKeyEntryDecoder
extends AbstractPrivateKeyEntryDecoder<EdDSAPublicKey, EdDSAPrivateKey> {
    public static final OpenSSHEd25519PrivateKeyEntryDecoder INSTANCE = new OpenSSHEd25519PrivateKeyEntryDecoder();
    private static final int PK_SIZE = 32;
    private static final int SK_SIZE = 32;
    private static final int KEYPAIR_SIZE = 64;

    public OpenSSHEd25519PrivateKeyEntryDecoder() {
        super(EdDSAPublicKey.class, EdDSAPrivateKey.class, Collections.unmodifiableList(Collections.singletonList("ssh-ed25519")));
    }

    @Override
    public EdDSAPrivateKey decodePrivateKey(String keyType, FilePasswordProvider passwordProvider, InputStream keyData) throws IOException, GeneralSecurityException {
        if (!"ssh-ed25519".equals(keyType)) {
            throw new InvalidKeyException("Unsupported key type: " + keyType);
        }
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchAlgorithmException("EdDSA provider not supported");
        }
        byte[] pk = KeyEntryResolver.readRLEBytes(keyData);
        byte[] keypair = KeyEntryResolver.readRLEBytes(keyData);
        if (pk.length != 32) {
            throw new InvalidKeyException(String.format(Locale.ENGLISH, "Unexpected pk size: %s (expected %s)", pk.length, 32));
        }
        if (keypair.length != 64) {
            throw new InvalidKeyException(String.format(Locale.ENGLISH, "Unexpected keypair size: %s (expected %s)", keypair.length, 64));
        }
        byte[] sk = Arrays.copyOf(keypair, 32);
        if (!Arrays.equals(pk, Arrays.copyOfRange(keypair, 32, 64))) {
            throw new InvalidKeyException("Keypair did not contain the public key.");
        }
        EdDSANamedCurveSpec params = EdDSANamedCurveTable.getByName("Ed25519");
        EdDSAPrivateKey privateKey = (EdDSAPrivateKey)this.generatePrivateKey(new EdDSAPrivateKeySpec(sk, params));
        if (!Arrays.equals(privateKey.getAbyte(), pk)) {
            throw new InvalidKeyException("The provided pk does NOT match the computed pk for the given sk.");
        }
        return privateKey;
    }

    @Override
    public String encodePrivateKey(OutputStream s, EdDSAPrivateKey key) throws IOException {
        Objects.requireNonNull(key, "No private key provided");
        byte[] sk = key.getSeed();
        byte[] pk = key.getAbyte();
        Objects.requireNonNull(sk, "No seed");
        byte[] keypair = new byte[64];
        System.arraycopy(sk, 0, keypair, 0, 32);
        System.arraycopy(pk, 0, keypair, 32, 32);
        KeyEntryResolver.writeRLEBytes(s, pk);
        KeyEntryResolver.writeRLEBytes(s, keypair);
        return "ssh-ed25519";
    }

    @Override
    public boolean isPublicKeyRecoverySupported() {
        return true;
    }

    @Override
    public EdDSAPublicKey recoverPublicKey(EdDSAPrivateKey prvKey) throws GeneralSecurityException {
        return EdDSASecurityProviderUtils.recoverEDDSAPublicKey(prvKey);
    }

    @Override
    public EdDSAPublicKey clonePublicKey(EdDSAPublicKey key) throws GeneralSecurityException {
        if (key == null) {
            return null;
        }
        return (EdDSAPublicKey)this.generatePublicKey(new EdDSAPublicKeySpec(key.getA(), key.getParams()));
    }

    @Override
    public EdDSAPrivateKey clonePrivateKey(EdDSAPrivateKey key) throws GeneralSecurityException {
        if (key == null) {
            return null;
        }
        return (EdDSAPrivateKey)this.generatePrivateKey(new EdDSAPrivateKeySpec(key.getSeed(), key.getParams()));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("EdDSA");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("EdDSA");
    }
}

