/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html.types;

import com.google.common.annotations.GwtCompatible;
import com.google.common.html.types.BuilderUtils;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.TrustedResourceUrl;

@GwtCompatible
public final class SafeHtmls {
    public static SafeHtml fromProto(SafeHtmlProto proto) {
        return SafeHtmls.create(proto.getPrivateDoNotAccessOrElseSafeHtmlWrappedValue());
    }

    public static SafeHtml fromScript(SafeScript script) {
        return SafeHtmls.create("<script type=\"text/javascript\">" + script.getSafeScriptString() + "</script>");
    }

    public static SafeHtml fromScriptUrl(TrustedResourceUrl trustedResourceUrl) {
        String escapedUrl = SafeHtmls.htmlEscapeInternal(trustedResourceUrl.getTrustedResourceUrlString());
        return SafeHtmls.create("<script type=\"text/javascript\" src=\"" + escapedUrl + "\"></script>");
    }

    public static SafeHtmlProto toProto(SafeHtml safeHtml) {
        return SafeHtmlProto.newBuilder().setPrivateDoNotAccessOrElseSafeHtmlWrappedValue(safeHtml.getSafeHtmlString()).build();
    }

    public static SafeHtml htmlEscape(String text) {
        return SafeHtmls.create(SafeHtmls.htmlEscapeInternal(text));
    }

    public static SafeHtml comment(String text) {
        return SafeHtmls.create("<!--" + SafeHtmls.htmlEscapeInternal(text) + "-->");
    }

    public static SafeHtml concat(SafeHtml ... htmls) {
        int concatLength = 0;
        for (int i = 0; i < htmls.length; ++i) {
            concatLength += htmls[i].getSafeHtmlString().length();
        }
        StringBuilder result = new StringBuilder(concatLength);
        for (int i = 0; i < htmls.length; ++i) {
            result.append(htmls[i].getSafeHtmlString());
        }
        return SafeHtmls.create(result.toString());
    }

    static SafeHtml create(String html) {
        return new SafeHtml(html);
    }

    private static String htmlEscapeInternal(String text) {
        return BuilderUtils.escapeHtmlInternal(BuilderUtils.coerceToInterchangeValid(text));
    }

    private SafeHtmls() {
    }
}

