/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html.types;

import com.google.common.annotations.GwtCompatible;
import com.google.common.html.types.CustomSafeUrlScheme;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.io.BaseEncoding;
import com.google.common.net.UrlEscapers;
import com.google.errorprone.annotations.CompileTimeConstant;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@GwtCompatible
public final class SafeUrls {
    private static final Set<String> DEFAULT_SAFE_SCHEMES = SafeUrls.createUnmodifiableSet("http", "https", "mailto", "ftp");
    private static final Set<CustomSafeUrlScheme> EMPTY_CUSTOM_SCHEMES = new HashSet<CustomSafeUrlScheme>();

    private SafeUrls() {
    }

    private static final Set<String> createUnmodifiableSet(String ... schemes) {
        HashSet<String> set = new HashSet<String>();
        for (String scheme : schemes) {
            set.add(scheme);
        }
        return Collections.unmodifiableSet(set);
    }

    public static SafeUrl fromProto(SafeUrlProto proto) {
        return SafeUrls.create(proto.getPrivateDoNotAccessOrElseSafeUrlWrappedValue());
    }

    public static SafeUrlProto toProto(SafeUrl url) {
        return SafeUrlProto.newBuilder().setPrivateDoNotAccessOrElseSafeUrlWrappedValue(url.getSafeUrlString()).build();
    }

    public static SafeUrl fromConstant(@CompileTimeConstant String url) {
        return SafeUrls.create(url);
    }

    public static SafeUrl sanitize(String url) {
        return SafeUrls.sanitize(url, EMPTY_CUSTOM_SCHEMES);
    }

    public static SafeUrl sanitize(String url, Set<CustomSafeUrlScheme> extraAllowedSchemes) {
        if (!SafeUrls.isSafeUrl(url, extraAllowedSchemes)) {
            return SafeUrl.INNOCUOUS;
        }
        return SafeUrls.create(url);
    }

    public static String sanitizeAsString(String url, @CompileTimeConstant String identifier) {
        if (!SafeUrls.isSafeUrl(url, EMPTY_CUSTOM_SCHEMES)) {
            return "about:invalid#" + identifier;
        }
        return url;
    }

    public static SafeUrl createHtmlDataUrl(SafeHtml html) {
        String dataUrl = "data:text/html;charset=UTF-8," + UrlEscapers.urlPathSegmentEscaper().escape(html.getSafeHtmlString());
        return SafeUrls.create(dataUrl);
    }

    public static SafeUrl createHtmlDataUrlBase64(SafeHtml html) {
        try {
            String dataUrl = "data:text/html;charset=UTF-8;base64," + BaseEncoding.base64().encode(html.getSafeHtmlString().getBytes("UTF-8"));
            return SafeUrls.create(dataUrl);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isSafeUrl(String url, Set<CustomSafeUrlScheme> extraAllowedSchemes) {
        String lowerCased = url.toLowerCase();
        for (String string : DEFAULT_SAFE_SCHEMES) {
            if (!lowerCased.startsWith(string + ":")) continue;
            return true;
        }
        for (CustomSafeUrlScheme customSafeUrlScheme : extraAllowedSchemes) {
            if (!lowerCased.startsWith(customSafeUrlScheme.name().toLowerCase() + ":")) continue;
            return true;
        }
        for (int i = 0; i < url.length(); ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    return true;
                }
                case '&': 
                case ':': {
                    return false;
                }
            }
        }
        return true;
    }

    static SafeUrl create(String url) {
        return new SafeUrl(url);
    }
}

