/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.api.changes;

import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.changes.AbandonInput;
import com.google.gerrit.extensions.api.changes.AddReviewerInput;
import com.google.gerrit.extensions.api.changes.AddReviewerResult;
import com.google.gerrit.extensions.api.changes.AssigneeInput;
import com.google.gerrit.extensions.api.changes.ChangeEditApi;
import com.google.gerrit.extensions.api.changes.FixInput;
import com.google.gerrit.extensions.api.changes.HashtagsInput;
import com.google.gerrit.extensions.api.changes.IncludedInInfo;
import com.google.gerrit.extensions.api.changes.MoveInput;
import com.google.gerrit.extensions.api.changes.RebaseInput;
import com.google.gerrit.extensions.api.changes.RestoreInput;
import com.google.gerrit.extensions.api.changes.RevertInput;
import com.google.gerrit.extensions.api.changes.ReviewerApi;
import com.google.gerrit.extensions.api.changes.RevisionApi;
import com.google.gerrit.extensions.api.changes.SubmittedTogetherInfo;
import com.google.gerrit.extensions.api.changes.SubmittedTogetherOption;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.common.CommitMessageInput;
import com.google.gerrit.extensions.common.EditInfo;
import com.google.gerrit.extensions.common.MergePatchSetInput;
import com.google.gerrit.extensions.common.PureRevertInfo;
import com.google.gerrit.extensions.common.RobotCommentInfo;
import com.google.gerrit.extensions.common.SuggestedReviewerInfo;
import com.google.gerrit.extensions.restapi.NotImplementedException;
import com.google.gerrit.extensions.restapi.RestApiException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ChangeApi {
    public String id();

    public RevisionApi current() throws RestApiException;

    public RevisionApi revision(int var1) throws RestApiException;

    public RevisionApi revision(String var1) throws RestApiException;

    public ReviewerApi reviewer(String var1) throws RestApiException;

    public void abandon() throws RestApiException;

    public void abandon(AbandonInput var1) throws RestApiException;

    public void restore() throws RestApiException;

    public void restore(RestoreInput var1) throws RestApiException;

    public void move(String var1) throws RestApiException;

    public void move(MoveInput var1) throws RestApiException;

    public void setPrivate(boolean var1, @Nullable String var2) throws RestApiException;

    public void setWorkInProgress(String var1) throws RestApiException;

    public void setReadyForReview(String var1) throws RestApiException;

    default public void setWorkInProgress() throws RestApiException {
        this.setWorkInProgress(null);
    }

    default public void setReadyForReview() throws RestApiException {
        this.setReadyForReview(null);
    }

    public void ignore(boolean var1) throws RestApiException;

    public boolean ignored() throws RestApiException;

    public void markAsReviewed(boolean var1) throws RestApiException;

    public ChangeApi revert() throws RestApiException;

    public ChangeApi revert(RevertInput var1) throws RestApiException;

    public ChangeInfo createMergePatchSet(MergePatchSetInput var1) throws RestApiException;

    public List<ChangeInfo> submittedTogether() throws RestApiException;

    public SubmittedTogetherInfo submittedTogether(EnumSet<SubmittedTogetherOption> var1) throws RestApiException;

    public SubmittedTogetherInfo submittedTogether(EnumSet<ListChangesOption> var1, EnumSet<SubmittedTogetherOption> var2) throws RestApiException;

    @Deprecated
    public void publish() throws RestApiException;

    public void rebase() throws RestApiException;

    public void rebase(RebaseInput var1) throws RestApiException;

    public void delete() throws RestApiException;

    public String topic() throws RestApiException;

    public void topic(String var1) throws RestApiException;

    public IncludedInInfo includedIn() throws RestApiException;

    public AddReviewerResult addReviewer(AddReviewerInput var1) throws RestApiException;

    public AddReviewerResult addReviewer(String var1) throws RestApiException;

    public SuggestedReviewersRequest suggestReviewers() throws RestApiException;

    public SuggestedReviewersRequest suggestReviewers(String var1) throws RestApiException;

    public ChangeInfo get(EnumSet<ListChangesOption> var1) throws RestApiException;

    default public ChangeInfo get(Iterable<ListChangesOption> options) throws RestApiException {
        return this.get(Sets.newEnumSet(options, ListChangesOption.class));
    }

    default public ChangeInfo get(ListChangesOption ... options) throws RestApiException {
        return this.get(Arrays.asList(options));
    }

    public ChangeInfo get() throws RestApiException;

    public ChangeInfo info() throws RestApiException;

    @Deprecated
    public EditInfo getEdit() throws RestApiException;

    public ChangeEditApi edit() throws RestApiException;

    public void setMessage(String var1) throws RestApiException;

    public void setMessage(CommitMessageInput var1) throws RestApiException;

    public void setHashtags(HashtagsInput var1) throws RestApiException;

    public Set<String> getHashtags() throws RestApiException;

    public AccountInfo setAssignee(AssigneeInput var1) throws RestApiException;

    public AccountInfo getAssignee() throws RestApiException;

    public List<AccountInfo> getPastAssignees() throws RestApiException;

    public AccountInfo deleteAssignee() throws RestApiException;

    public Map<String, List<CommentInfo>> comments() throws RestApiException;

    public Map<String, List<RobotCommentInfo>> robotComments() throws RestApiException;

    public Map<String, List<CommentInfo>> drafts() throws RestApiException;

    public ChangeInfo check() throws RestApiException;

    public ChangeInfo check(FixInput var1) throws RestApiException;

    public void index() throws RestApiException;

    public PureRevertInfo pureRevert() throws RestApiException;

    public PureRevertInfo pureRevert(String var1) throws RestApiException;

    public static class NotImplemented
    implements ChangeApi {
        @Override
        public String id() {
            throw new NotImplementedException();
        }

        @Override
        public RevisionApi current() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public RevisionApi revision(int id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ReviewerApi reviewer(String id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public RevisionApi revision(String id) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void abandon() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void abandon(AbandonInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void restore() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void restore(RestoreInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void move(String destination) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void move(MoveInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void setPrivate(boolean value, @Nullable String message) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void setWorkInProgress(String message) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void setReadyForReview(String message) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeApi revert() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeApi revert(RevertInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void publish() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        @Deprecated
        public void rebase() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void rebase(RebaseInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void delete() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public String topic() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void topic(String topic) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public IncludedInInfo includedIn() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public AddReviewerResult addReviewer(AddReviewerInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public AddReviewerResult addReviewer(String in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public SuggestedReviewersRequest suggestReviewers() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public SuggestedReviewersRequest suggestReviewers(String query) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeInfo get(EnumSet<ListChangesOption> options) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeInfo get() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeInfo info() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void setMessage(String message) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void setMessage(CommitMessageInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public EditInfo getEdit() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeEditApi edit() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void setHashtags(HashtagsInput input) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public Set<String> getHashtags() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public AccountInfo setAssignee(AssigneeInput input) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public AccountInfo getAssignee() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public List<AccountInfo> getPastAssignees() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public AccountInfo deleteAssignee() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public Map<String, List<CommentInfo>> comments() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public Map<String, List<RobotCommentInfo>> robotComments() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public Map<String, List<CommentInfo>> drafts() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeInfo check() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeInfo check(FixInput fix) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void index() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public List<ChangeInfo> submittedTogether() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public SubmittedTogetherInfo submittedTogether(EnumSet<SubmittedTogetherOption> options) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public SubmittedTogetherInfo submittedTogether(EnumSet<ListChangesOption> a, EnumSet<SubmittedTogetherOption> b) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public ChangeInfo createMergePatchSet(MergePatchSetInput in) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void ignore(boolean ignore) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public boolean ignored() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public void markAsReviewed(boolean reviewed) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public PureRevertInfo pureRevert() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public PureRevertInfo pureRevert(String claimedOriginal) throws RestApiException {
            throw new NotImplementedException();
        }
    }

    public static abstract class SuggestedReviewersRequest {
        private String query;
        private int limit;

        public abstract List<SuggestedReviewerInfo> get() throws RestApiException;

        public SuggestedReviewersRequest withQuery(String query) {
            this.query = query;
            return this;
        }

        public SuggestedReviewersRequest withLimit(int limit) {
            this.limit = limit;
            return this;
        }

        public String getQuery() {
            return this.query;
        }

        public int getLimit() {
            return this.limit;
        }
    }
}

